// ============================================================================
//  $Id: TReadoutList.hh,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TREADOUTLIST_HH
#define __TREADOUTLIST_HH

#include "TGlobals.hh"
#include "TReadoutSectionList.hh"

class TDataRecord;

class TReadoutList
  : public TReadoutSectionList
{

  private:
    Tint theID;

  public:
    TReadoutList( Tint id = tIDunknown );
    TReadoutList( const TReadoutList& right );
    ~TReadoutList();

  public:
    const TReadoutList& operator=( const TReadoutList& right );
    Tbool operator==( const TReadoutList& right ) const;
    Tbool operator!=( const TReadoutList& right ) const;
    friend Tostream& operator<<( Tostream& tos, const TReadoutList& right );

  public:
    TDataRecord ReadData();    

  public:
    Tint GetID() const;
    Tvoid SetID( Tint id );

};

inline Tint TReadoutList::GetID() const
{
  return( theID );
}

inline Tvoid TReadoutList::SetID( Tint id )
{
  theID = id;
  return;
}

#endif
