// ============================================================================
//  $Id: TOutputHtmlFileStream.hh,v 1.3 2002/12/08 21:21:48 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TOUTPUTHTMLFILESTREAM_HH
#define __TOUTPUTHTMLFILESTREAM_HH

#include "TGlobals.hh"
#include "TRunInformationTable.hh"

class TOutputHtmlFileStream
  : public Tofstream
{

  protected:
    TRunInformationTable theInformationTable;

  public:
    TOutputHtmlFileStream();
    TOutputHtmlFileStream( const Tstring& filename, const TRunInformationTable& table );
    TOutputHtmlFileStream( const TRunInformationTable& table );
    TOutputHtmlFileStream( const Tstring& filename );
    ~TOutputHtmlFileStream();

  public:
    virtual TOutputHtmlFileStream& MakeTable();

  public:
    const TRunInformationTable& GetInformationTable() const;
    TRunInformationTable& GetInformationTable();
    Tvoid SetInformationTable( const TRunInformationTable& table );
    Tvoid Open( const Tstring& filename );
    Tvoid Close();

};

inline const TRunInformationTable& TOutputHtmlFileStream::GetInformationTable() const
{
  return( theInformationTable );
}

inline TRunInformationTable& TOutputHtmlFileStream::GetInformationTable()
{
  return( theInformationTable );  
}

inline Tvoid TOutputHtmlFileStream::SetInformationTable( const TRunInformationTable& table )
{
  theInformationTable = table;
  return;
}

#endif
