// ============================================================================
//  $Id: run+event.cc,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TGlobals.hh"
#include "TRun.hh"
#include "TEvent.hh"
#include "TEventList.hh"
#include "TDataRecord.hh"
#include "TReadoutList.hh"
#include "TReadoutSection.hh"
#include "TReadoutSegment.hh"
#include "TSoftwareScalerModule.hh"
#include "TSoftwareTimerModule.hh"
#include "TSoftwareClockModule.hh"
#include "TSoftwareAdcModule.hh"

int main( int argc, char** argv, char** envv )
{
  const Tint nevents = 10;
  TRun run;

  TSoftwareScalerModule scaler;
  TSoftwareTimerModule timer;
  TSoftwareClockModule clock;
  TSoftwareAdcModule adc;
  TReadoutList list( 1000 );
  TReadoutSection sec1( 1100 );
  TReadoutSegment seg1( &scaler, 1100 );
  TReadoutSegment seg2( &clock, 1200 );
  TReadoutSegment seg3( &timer, 1300 );
  TReadoutSegment seg4( &adc, 1400 );
  sec1.push_back( seg1 );
  sec1.push_back( seg2 );
  sec1.push_back( seg3 );
  sec1.push_back( seg4 );
  list.push_back( sec1 );


  for ( Tint eventid = 0; eventid < nevents; eventid ++ ) {
    TEvent event = TEvent( eventid, list.ReadData() );

    // record event in the run
    TEventList& evtlist = (TEventList&)( run.GetEventList() );
    evtlist.push_back( event );



    const TEventList& events = run.GetEventList();
    Tcout << "################################################" << Tendl;
    for ( Tint i = 0; i < (Tint)events.size(); i ++ )
      Tcout << events[ i ].GetDataRecord() << Tendl;
    Tcout << "################################################" << Tendl;
    Tcout << Tendl;



    scaler.Update();
    clock.Update();
    timer.Update();
    adc.Update();
  }
  

  return( 0 );
}
