// ============================================================================
//  $Id: socketInput.cc,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TGlobals.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TInputObjectSocket.hh"

int main( int argc, char** argv, char** envv )
{
  enum { exCommand, exPort, exNumberOfArguments };
  if ( argc != exNumberOfArguments ) {
    Tcerr << "usage: " << argv[ exCommand ] << Tspace << "<port>" << Tendl;
    return( -1 );
  }
  const Tint port = atoi( argv[ exPort ] );
  TInputObjectSocket* isocket = new TInputObjectSocket( port );

  Tint counter = 0;
  Tint datasize1 = 0;
  Tint datasize2 = 0;

  TDataRecord record;
  while ( ( isocket -> ReadData( record ) ) != 0 ) {
    Tcout << record << Tendl;
    datasize1 += record.GetDataSize();
    datasize2 += isocket -> GetDataSize();
    counter ++;
  }

  Tcout << Tendl;
  Tcout << Ttab << counter << " event, ";
  Tcout << datasize1 << Tslash << datasize2;
  Tcout << " byte data has been received." << Tendl;
  Tcout << Tendl;

  delete isocket;
  return( 0 );
}
