// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "Dark1DHistogramExtractor.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

Dark1DHistogramExtractor::Dark1DHistogramExtractor()
  : TAnalysisDataExtractor()
{;}

Dark1DHistogramExtractor::~Dark1DHistogramExtractor()
{;}

Tvoid Dark1DHistogramExtractor::Extract( const TDataRecord& record )
{
  static const Tint findsegID = 1210;
  static const Tint findch = 0;
  TDataSection section;
  TDataSegment segment;
  TDataElement element;
  TUshort* databuf = 0;
  TdoubleList linebuf( 16, 0.0 );
  TMultipleData mdata;


  for ( Tsize_t i = 0; i < record.size(); i ++ ) {
    section = record[ i ];
    for ( Tsize_t j = 0; j < section.size(); j ++ ) {
      segment = section[ j ];
      if ( segment.GetID() == findsegID ) {
	element = segment[ findch ];
	databuf = (TUshort*)( element.GetData() );
	Tint nprvs = element.GetNumberOfPrimitives();
	for ( Tint k = 0; k < nprvs; k ++ ) {
	  linebuf[ 0 ] = (Tdouble)( databuf[ k ] );
  	  mdata.push_back( linebuf );
	}
	theMultipleData = mdata;
      }
    }
  }

  return;
}
