// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TEventManager.hh"
#include "TDataRecord.hh"
#include "TEventAction.hh"
#include "TEventList.hh"
#include "TReadoutList.hh"
#include "TRun.hh"

TEventManager* TEventManager::theEventManager = 0;

TEventManager::TEventManager( Tint stacksize )
  : theStackSize( stacksize ), theNumberOfEvents( 0 ), theEventAction( 0 ),
    theEvent( 0, TDataRecord() )
{
  if ( theEventManager ) {
    Tcerr << "TEventManager::TEventManager: EventManager constructed twice." << Tendl;
    exit( -EFAULT );
  }
  theEventManager = this;
}

TEventManager::~TEventManager()
{
  if ( theEventAction )
    delete theEventAction;
  theEventManager = 0;
}

const TEvent& TEventManager::TakeEvent()
{
  theEvent.Clear();
  theEvent.SetEventID( theNumberOfEvents );
  if ( theEventAction ) {
    theEventAction -> BeginOfEventAction( theEvent );
    const TReadoutList* readout = theEventAction -> WaitEvent();
    TDataRecord record = readout -> ReadData();
    theEvent.SetDataRecord( record );
    theEventAction -> EndOfEventAction( theEvent );
  }
  theNumberOfEvents ++;
  return( theEvent );
}

Tvoid TEventManager::RecordEvent( const TRun& run )
{
  const TEventList& evtlist = run.GetEventList();
  if ( theNumberOfEvents >= theStackSize )
    evtlist.erase( evtlist.begin() );
  evtlist.push_back( theEvent );
  return;
}
