// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TTYPES_HH
#define __TTYPES_HH

#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <stdio.h>
#include <string>
#include <list>
#include <vector>

#define Tfalse 0
#define Ttrue 1
#define Tstd std
#define Tios Tstd::ios
#define Tin Tios::inin
#define Tout Tios::out
#define Tate Tios::ate
#define Tapp Tios::app
#define Ttrunc Tios::trunc
#define Tnocreate Tios::nocreate
#define Tnoreplace Tios::noreplace
#define Tbin Tios::bin
#define Tbinary Tios::binary
#define Tgoodbit Tios::goodbit
#define Teofbit Tios::eofbit
#define Tfailbit Tios::failbit
#define Tbadbit Tios::badbit
#define Tostream Tstd::ostream
#define Tlist Tstd::list
#define Tvector Tstd::vector
#define Tcout Tstd::cout
#define Tcin Tstd::cin
#define Tcerr Tstd::cerr
#define Tendl Tstd::endl
#define Tends Tstd::ends
#define Tdec Tstd::dec
#define Thex Tstd::hex
#define Toct Tstd::oct
#define Tflush Tstd::flush
#define Tsizeof(A) sizeof(A)


typedef double Tdouble;
typedef int Tint;
typedef float Tfloat;
typedef char Tchar;
typedef long Tlong;
typedef unsigned char TUchar;
typedef unsigned int TUint;
typedef unsigned long TUlong;
typedef short Tshort;
typedef unsigned short TUshort;
typedef bool Tbool;
typedef Tbool Tbit;
typedef FILE TFileStream;
typedef size_t Tsize_t;
typedef time_t Ttime_t;
typedef socklen_t Tsocklen_t;
typedef caddr_t Tcaddr_t;
typedef off_t Toff_t;
typedef void Tvoid;
typedef Tstd::string Tstring;
typedef ofstream Tofstream;
typedef ifstream Tifstream;
typedef Tvector<Tint> TintList;
typedef Tvector<TUshort> TUshortList;
typedef Tvector<Tdouble> TdoubleList;
typedef Tvector<Tfloat> TfloatList;
typedef Tvector<Tstring> TstringList;

static const Tstring Tspace = " ";
static const Tstring Thyphen = "-";
static const Tstring Tslash = "/";
static const Tstring Twslash = Tslash + Tslash;
static const Tstring Tsharp = "#";
static const Tstring Tpipe = "|";
static const Tstring Twspace = Tspace + Tspace;
static const Tstring Ttab = "\t";
static const Tstring Tbeep = "\b";
static const Tstring Tmsec = "ms";
static const Tstring Tsec = "s";
static const Tstring Tusec = "us";
static const Tstring Tproject = "ccd-daq";
static const Tstring Tversion = "1.0.0";
static const Tstring Texit = "exit";
static const Tstring Tprompt = Tproject + Thyphen + Tversion + ">" + Tspace;
static const Tchar Tkey = '\x01';
static const Tchar Teol = '\n';

enum Tobject_t { 
  tDataRecord,
  tDataSection,
  tDataSegment,
  tDataElement,
  tNumberOfObjectTypes,
  tDataUnknown = -1
};

enum Telement_t {
  tTypeInt,
  tTypeString,
  tTypeDouble,
  tTypeObject,
  tTypeFloat,
  tNumberOfElementTypes,
  tTypeUnsignedShort,
  tTypeShort,
  tTypeWord,
  tTypeUnknown = -1
};

enum Tstream_t { 
  tFileStream,
  tSocketStream,
  tSharedMemoryStream,
  tNumberOfStreamTypes,
  tUnknownStream = -1
};

enum Trandom_t {
  tRandomExponential,
  tRandomGaussian,
  tRandomChiSquare,
  tRandomLandau,
  tRandomGamma,
  tRandomPoisson,
  tNumberOfRandomTypes,
  tRandomUnknown = -1
};

enum Tstatus_t {
  tStatusStandby,
  tStatusReady,
  tStatusBusy,
  tStatusIdle,
  tStatusWaitingReady,
  tStatusDead,
  tNumberOfStatusTypes,
  tStatusUnknown = -1
};

enum TvmeTransfer_t {
  tA16D16,
  tA16D32,
  tA24D16,
  tA24D32,
  tA32D16,
  tA32D32,
  tA24D16dma,
  tA32D16dma,
  tA24D32dma,
  tA32D32dma, 
  tNumberOfVmeTransferModes,
  tTransferModeUnknown = -1
};

static const Tstring TvmeDevices[ tNumberOfVmeTransferModes ] =
{
  "/dev/vmedrv16d16",
  "/dev/vmedrv16d32",
  "/dev/vmedrv24d16",
  "/dev/vmedrv24d32",
  "/dev/vmedrv32d16",
  "/dev/vmedrv32d32",
  "/dev/vmedrv24d16dma",
  "/dev/vmedrv32d16dma",
  "/dev/vmedrv24d32dma",
  "/dev/vmedrv32d32dma"
};

enum { 
  tIDunknown = -1
};

#endif
