// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TUserInterface.hh"
#include "TCommand.hh"

TUserInterface::TUserInterface( const Tstring& history )
  : theCommandListCapacity( 1 ), theNumberOfCommands( 0 ), theCommandIndex( 0 )
{
  theHistoryFileStream.open( history.c_str(), ios::out );
  if ( !( theHistoryFileStream.good() ) ) {
    Tcerr << "TUserInterface::TUserInterface: fail to open a file ";
    Tcerr << history << "." << Tendl;
  }
  allocate( theCommandListCapacity );
}

TUserInterface::~TUserInterface()
{
  free();
  theHistoryFileStream.close();
}

Tint TUserInterface::AddCommand( TCommand* command )
{
  if ( theNumberOfCommands >= theCommandListCapacity )
    ResizeCommandList( theCommandListCapacity *= 2 );
  theCommandList[ theNumberOfCommands ] = command;
  theNumberOfCommands ++;
  theCommandIndex = theNumberOfCommands - 1;
  return( theNumberOfCommands );
}

Tint TUserInterface::RemoveCommand( Tint index )
{
  if ( index < 0 || index >= theNumberOfCommands ) {
    Tcerr << "TUserInterface::RemoveCommand: invalid index" << Tendl;
    return( 0 );
  }
  theCommandIndex = index;
  delete theCommandList[ theCommandIndex ];
  for ( Tint i = theCommandIndex; i < theNumberOfCommands; i ++ )
    theCommandList[ i ] = theCommandList[ i + 1 ];
  theNumberOfCommands --;
  return( theNumberOfCommands );
}

Tvoid TUserInterface::ClearCommandList()
{
  for ( Tint i = 0; i < theNumberOfCommands; i ++ )
    if ( theCommandList[ i ] )
      delete theCommandList[ i ];
  theNumberOfCommands = 0;
  theCommandIndex = 0;
  return;
}

Tbool TUserInterface::ResizeCommandList( Tint capacity )
{
  if ( theNumberOfCommands >= capacity ) {
    Tcerr << "TUserInterface::ResizeCommandList: invalid capacity" << Tendl;
    return( Tfalse );
  }
  theCommandListCapacity = capacity;
  TCommand** newcommands = new TCommand* [ theCommandListCapacity ];
  for ( Tint i = 0; i < theNumberOfCommands; i ++ )
    newcommands[ i ] = theCommandList[ i ];
  delete [] theCommandList;
  theCommandList = newcommands;
  theCommandIndex = theNumberOfCommands - 1;
  return( Ttrue );
}

TCommand* TUserInterface::NextCommand()
{
  if ( theCommandIndex < 0 || theCommandIndex >= theNumberOfCommands )
    return( 0 );
  return( theCommandList[ theCommandIndex ++ ] );
}

TCommand* TUserInterface::FindCommand( const Tstring& command )
{
  Tint indexbuf = theCommandIndex;
  theCommandIndex = 0;
  TCommand* com = 0;
  while ( ( com = NextCommand() ) ) {
    if ( com -> GetCommandName() == command ) {
      theCommandIndex = indexbuf;
      return( com );
    }
  }
  theCommandIndex = indexbuf;
  return( 0 );
}

TCommand* TUserInterface::GetCommand( Tint index )
{
  if ( index < 0 || index >= theNumberOfCommands ) {
    Tcerr << "TUserInterface::GetCommand: invalid index" << Tendl;
    return( 0 );
  }
  theCommandIndex = index;
  return( theCommandList[ theCommandIndex ] );
}

TCommand* TUserInterface::GetCommand()
{
  return( GetCommand( theCommandIndex ) );
}

Tvoid TUserInterface::ExecuteCommand( const Tstring& command, const TstringList& arguments )
{
  TCommand* com = FindCommand( command );
  if ( com != 0 )
    com -> Execute( arguments );
  return;
}

Tvoid TUserInterface::ExecuteCommand( const Tstring& command )
{
  TstringList args;
  return( ExecuteCommand( command, args ) );
}

Tvoid TUserInterface::free()
{
  for ( Tint i = 0; i < theNumberOfCommands; i ++ )
    if ( theCommandList[ i ] )
      delete theCommandList[ i ];
  delete [] theCommandList;
  theCommandListCapacity = 0;
  theNumberOfCommands = 0;
  theCommandIndex = 0;
  return;
}

Tvoid TUserInterface::allocate( Tint capacity )
{
  theCommandListCapacity = capacity;
  theCommandList = new TCommand* [ theCommandListCapacity ];
  return;
}
