// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TVMEDAUGHTERBOARDMEMORYMODULE_HH
#define __TVMEDAUGHTERBOARDMEMORYMODULE_HH

#include "TGlobals.hh"
#include "TVmeModule.hh"

class TDataSegment;
class TDataElement;

class TVmeDaughterBoardMemoryModule
  : public TVmeModule
{

  private:
    Tint theNumberOfSampling;

  public:
    TVmeDaughterBoardMemoryModule( Tint baseaddress, Tint mapsize, Tint nsamples );
    TVmeDaughterBoardMemoryModule( const TVmeDaughterBoardMemoryModule& right );
    ~TVmeDaughterBoardMemoryModule();

  public:
    const TVmeDaughterBoardMemoryModule& operator=( const TVmeDaughterBoardMemoryModule& right );
    Tbool operator==( const TVmeDaughterBoardMemoryModule& right ) const;
    Tbool operator!=( const TVmeDaughterBoardMemoryModule& right ) const;

  public:
    Tint GetNumberOfSampling() const;
    Tvoid SetNumberOfSampling( Tint nsamples );

  public:
    Tint Clear();
    Tint Update();
    Tint Initialize();
    Tvoid FillData( const TDataSegment& segment );
    Tvoid FillData( const TDataElement& element );

  private:
    const TUshort& modifyData( TUshort& databuf ) const;

};

inline Tint TVmeDaughterBoardMemoryModule::GetNumberOfSampling() const
{
  return( theNumberOfSampling );
}

inline Tvoid TVmeDaughterBoardMemoryModule::SetNumberOfSampling( Tint nsamples )
{
  theNumberOfSampling = nsamples;
  return;
}

inline const TUshort& TVmeDaughterBoardMemoryModule::modifyData( TUshort& databuf ) const
{
  Tbit sign = ( databuf & 0x8000 ) >> 15;
  if ( sign ) { // negative value
    databuf &= 0x7fff;
    databuf = databuf >> 4;
  } else { // positive value
    databuf = databuf >> 4;
    databuf += 0x07ff;
  }
  return( databuf );
}

#endif
