// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TReadoutElement.hh"
#include "TDataElement.hh"
#include "TModule.hh"

TReadoutElement::TReadoutElement( TModule* module, Tint id )
  : theID( id ), theModule( module )
{;}

TReadoutElement::TReadoutElement( const TReadoutElement& right )
  : theID( right.theID ), theModule( right.theModule )
{;}

TReadoutElement::~TReadoutElement()
{;}

TDataElement TReadoutElement::ReadData()
{
  TDataElement element( tTypeUnknown, theID );
  theModule -> FillData( element );
  return( element );
}

Tostream& operator<<( Tostream& tos, const TReadoutElement& right )
{
  Tstring head = Twspace + Twspace + Twspace + "* Readout Element, ";
  tos << head << "ID: " << right.theID;
  // module 򤳤θפǤʤ߷ѹ
  return( tos );
}

const TReadoutElement& TReadoutElement::operator=( const TReadoutElement& right )
{
  theID = right.theID;
  theModule = right.theModule;
  return( *this );
}

Tbool TReadoutElement::operator==( const TReadoutElement& right ) const
{
  if ( theID == right.theID && theModule == right.theModule )
    return( Ttrue );
  else
    return( Tfalse );
}

Tbool TReadoutElement::operator!=( const TReadoutElement& right ) const
{
  if ( theID != right.theID || theModule != right.theModule )
    return( Ttrue );
  else
    return( Tfalse );
}

