// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TRun.hh"

TRun::TRun()
  : theRunID( 0 ), theEventList()
{
  theEventList.clear();
}

TRun::TRun( const TRun& right )
  : theRunID( right.theRunID ), theEventList( right.theEventList )
{;}

TRun::~TRun()
{;}

const TRun& TRun::operator=( const TRun& right )
{
  theRunID = right.theRunID;
  theEventList = right.theEventList;
  return( *this );
}

Tbool TRun::operator==( const TRun& right ) const
{
  if ( theRunID == right.theRunID && theEventList == right.theEventList )
    return( Ttrue );
  else
    return( Tfalse );
}

Tbool TRun::operator!=( const TRun& right ) const
{
  if ( theRunID != right.theRunID || theEventList != right.theEventList )
    return( Ttrue );
  else
    return( Tfalse );
}

Tvoid TRun::Clear()
{
  theEventList.clear();
  return;
}
