// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TGlobals.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<filename>" << Tendl;
    return( -1 );
  }
  const Tstring filename = argv[ 1 ];
  TInputObjectFile* ifile = new TInputObjectFile( filename );
  Tint counter = 0;
  Tint datasize1 = 0;
  Tint datasize2 = 0;

  TDataRecord record;
  while ( ( ifile -> ReadData( record ) ) != 0 ) {
    Tcout << record << Tendl;
    datasize1 += record.GetDataSize();
    datasize2 += ifile -> GetDataSize();
    counter ++;
  }

  Tcout << Tendl;
  Tcout << Ttab << counter << " event, ";
  Tcout << datasize1 << Tslash << datasize2;
  Tcout << " byte data has been read from " << filename << Tendl;
  Tcout << Tendl;

  delete ifile;
  return( 0 );
}
