// ============================================================================
//  $Id: BtDummyModuleManager.hh,v 1.1 2002/12/07 13:14:40 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __BTDUMMYMODULEMANAGER_HH
#define __BTDUMMYMODULEMANAGER_HH

#include "globals.h"
#include "TSoftwareAdcModule.hh"
#include "TSoftwareScalerModule.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TSoftwareTimerModule.hh"
#include "TSoftwareClockModule.hh"
#include "TReadoutList.hh"

class TSoftwareAdcModule;
class TSoftwareScalerModule;
class TSoftwareRunInformationModule;
class TSoftwareTimerModule;
class TSoftwareClockModule;
class TReadoutList;

class BtDummyModuleManager
{

  private:
    static BtDummyModuleManager* theModuleManager;

  private:
    TSoftwareAdcModule* theAdc;
    TSoftwareScalerModule* theScaler;
    TSoftwareRunInformationModule* theRunInfo;
    TSoftwareTimerModule* theTimer;
    TSoftwareClockModule* theClock;
    TReadoutList* theRunBeginReadoutList;
    TReadoutList* theRunEndReadoutList;
    TReadoutList* theEventReadoutList;
    TReadoutList* theScalerEventReadoutList;

  public:
    BtDummyModuleManager();
    ~BtDummyModuleManager();

  public:
    static BtDummyModuleManager* GetModuleManager();

  public:
    const TSoftwareAdcModule* GetAdc() const;
    const TSoftwareScalerModule* GetScaler() const;
    TSoftwareRunInformationModule* GetRunInfo() const;
    const TSoftwareTimerModule* GetTimer() const;
    const TSoftwareClockModule* GetClock() const;
    TReadoutList* GetRunBeginReadoutList() const;
    TReadoutList* GetRunEndReadoutList() const;
    const TReadoutList* GetEventReadoutList() const;
    const TReadoutList* GetScalerEventReadoutList() const;

  public:
    Tvoid Update();

  private:
    Tvoid defineModule();
    Tvoid defineReadoutList();
    
};

inline BtDummyModuleManager* BtDummyModuleManager::GetModuleManager()
{
  return( theModuleManager );
}

inline const TSoftwareAdcModule* BtDummyModuleManager::GetAdc() const
{
  return( theAdc );
}

inline const TSoftwareScalerModule* BtDummyModuleManager::GetScaler() const
{
  return( theScaler );
}

inline TSoftwareRunInformationModule* BtDummyModuleManager::GetRunInfo() const
{
  return( theRunInfo );
}

inline const TSoftwareTimerModule* BtDummyModuleManager::GetTimer() const
{
  return( theTimer );
}

inline const TSoftwareClockModule* BtDummyModuleManager::GetClock() const
{
  return( theClock );
}

inline TReadoutList* BtDummyModuleManager::GetRunBeginReadoutList() const
{
  return( theRunBeginReadoutList );
}

inline TReadoutList* BtDummyModuleManager::GetRunEndReadoutList() const
{
  return( theRunEndReadoutList );
}

inline const TReadoutList* BtDummyModuleManager::GetEventReadoutList() const
{
  return( theEventReadoutList );
}

inline const TReadoutList* BtDummyModuleManager::GetScalerEventReadoutList() const
{
  return( theScalerEventReadoutList );
}

#endif
