// ============================================================================
//  $Id: BtEventAction.cc,v 1.6 2002/12/09 07:20:36 iwai Exp $
//  $Name:  $
// ============================================================================
#include "BtEventAction.hh"
#include "BtRunAction.hh"
#include "BtModuleManager.hh"
#include "BtRunSummary.hh"
#include "parameter.h"
#include "TRunManager.hh"
#include "TOutputObjectFile.hh"
#include "TCamacInterruptRegisterModule.hh"
#include "TCamacOutputRegisterModule.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

BtEventAction::BtEventAction( BtModuleManager* manager )
  : theModuleManager( manager )
{;}

BtEventAction::~BtEventAction()
{;}

Tvoid BtEventAction::BeginOfEventAction( TEvent& anEvent )
{
  //begin -> (update) -> wait -> read -> end
  theModuleManager -> GetOutput() -> Pulse( 0x0001 );  // bit pattern
  return;
}

const TReadoutList& BtEventAction::WaitEvent()
{
  // define trigger.
  enum { nosignal = 0x0000, event = 0x0001, scaler = 0x0002, both = 0x0003 };

  TCamacInterruptRegisterModule* ir = theModuleManager -> GetInterrupt();
  Tbool trigger = Tfalse;
  TUint trgtype = nosignal;
  do {
    ir -> ReadInterruptRegister();
    if ( ir -> GetCamacData() != nosignal ) {
      trigger = Ttrue;
      trgtype = ir -> GetCamacData();
    } else {
      // usleep?
    }
  } while ( trigger == Tfalse );

  if ( trgtype == event || trgtype == both ) {
    return( *( theModuleManager -> GetEventReadoutList() ) );
  } else if ( trgtype == scaler ) {
    return( *( theModuleManager -> GetScalerEventReadoutList() ) );
  } else {
    Tcerr << "unnown trigger, exception occured." << Tendl;
    Tcerr << "check the hardware." << Tendl;
    return( *( theModuleManager -> GetEventReadoutList() ) );
  }
}

Tvoid BtEventAction::EndOfEventAction( TEvent& anEvent )
{
  BtRunAction* action =
    (BtRunAction*)( TRunManager::GetRunManager() -> GetRunAction() );
  TOutputObjectFile* ofile = action -> GetOutputFile();

  TDataRecord record = anEvent.GetDataRecord();
  ofile -> WriteData( record );

  if ( record.GetID() == BTevent ) {
    fillCsIEventInformation( record );
    theModuleManager -> Update( "csi" );
  } else if ( record.GetID() == BTscalerevent ) {
    fillScalerEventInformation( record );
    theModuleManager -> Update( "scaler" );
  } else {
    Tstring head = "BtEventAction::EndOfEventAction: ";
    Tcerr << head << "unkown trigger." << Tendl;
    Tcerr << record << Tendl;
    Tcerr << head << "confuse." << Tendl;    
  }

  return;
}

Tvoid BtEventAction::fillCsIEventInformation( const TDataRecord& record )
{
  BtRunAction* action =
    (BtRunAction*)( TRunManager::GetRunManager() -> GetRunAction() );
  BtRunSummary* summary = action -> GetRunSummary();
  
  Tint ncsi = summary -> GetNumberOfCsIEvents();
  Tint nevents = summary -> GetNumberOfAllEvents();
  summary -> SetNumberOfCsIEvents( ++ ncsi );
  summary -> SetNumberOfAllEvents( ++ nevents );

  return;
}

Tvoid BtEventAction::fillScalerEventInformation( const TDataRecord& record )
{
  BtRunAction* action =
    (BtRunAction*)( TRunManager::GetRunManager() -> GetRunAction() );
  BtRunSummary* summary = action -> GetRunSummary();

  Tint nscaler = summary -> GetNumberOfScalerEvents();
  Tint nevents = summary -> GetNumberOfAllEvents();

  TDataSection section = record[ 0 ];
  TDataSegment scaler = section[ 1 ];
  for ( Tsize_t i = 0; i < scaler.size(); i ++ ) {
    Tint buf = (Tint)( *( (TUint*)(scaler[ i ].GetData()) ) );
    summary -> AddAccumulatedScaler( i, buf );
  }

  summary -> SetNumberOfScalerEvents( ++ nscaler );
  summary -> SetNumberOfAllEvents( ++ nevents );

  return;
}
