// ============================================================================
//  $Id: BtEventViewerCommand.cc,v 1.1 2002/12/09 07:20:36 iwai Exp $
//  $Name:  $
// ============================================================================
#include "BtEventViewerCommand.hh"
#include "BtRunAction.hh"
#include "TRunManager.hh"
#include "TUserInterface.hh"
#include "TOutputObjectFile.hh"

static const Tstring name = "/local/eventview";
static const Tstring desc = "view histogram(ADC/Scaler).";

BtEventViewerCommand::BtEventViewerCommand( TRunManager* manager )
  : TCommand( manager, name, desc )
{;}

BtEventViewerCommand::~BtEventViewerCommand()
{;}

Tvoid BtEventViewerCommand::Execute( const TstringList& arguments )
{
  TUserInterface* ui = theRunManager -> GetUserInterface();
  BtRunAction* action = (BtRunAction*)( theRunManager -> GetRunAction() );
  Tstring filename = action -> GetOutputFile() -> GetFileName();
  Tstring com = "/system/shell";
  TstringList args;
  args.push_back( "./../../bin/eventview" );
  args.push_back( filename );
  args.push_back( "&" );

  ui -> ExecuteCommand( com, args );

  return;
}
