// ============================================================================
//  $Id: BtModuleManager.cc,v 1.5 2002/12/09 07:20:36 iwai Exp $
//  $Name:  $
// ============================================================================
#include "BtModuleManager.hh"
#include "TCamacCrateController.hh"
#include "TCamacAdcModule.hh"
#include "TCamacScalerModule.hh"
#include "TCamacInterruptRegisterModule.hh"
#include "TCamacOutputRegisterModule.hh"
#include "TCamacCoincidenceRegisterModule.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TSoftwareTimerModule.hh"
#include "TSoftwareClockModule.hh"
#include "TSoftwareScalerModule.hh"
#include "TRunInformationTable.hh"
#include "TReadoutList.hh"
#include "TReadoutSection.hh"
#include "TReadoutSegment.hh"
#include "TReadoutElement.hh"
#include "parameter.h"

BtModuleManager* BtModuleManager::theModuleManager = 0;

BtModuleManager::BtModuleManager()
  : theCrateController( 0 ), theAdc( 0 ), theScaler( 0 ), theOutput( 0 ),
    theCoincidence( 0 ), theInterrupt( 0 ),
    theRunInfo( 0 ), theTimer( 0 ), theClock( 0 ),
    theRunNumber( 0 ), theEventNumber( 0 ),
    theRunBeginReadoutList( 0 ), theRunEndReadoutList( 0 ),
    theEventReadoutList( 0 ), theScalerEventReadoutList( 0 )
{
  defineModule();
  defineReadoutList();
  theModuleManager = this;
}

BtModuleManager::~BtModuleManager()
{
  delete theCrateController;
  delete theAdc;
  delete theScaler;
  delete theCoincidence;
  delete theInterrupt;
  delete theRunInfo;
  delete theTimer;
  delete theClock;
  delete theRunNumber;
  delete theEventNumber;
  delete theRunBeginReadoutList;
  delete theRunEndReadoutList;
  delete theEventReadoutList;
  delete theScalerEventReadoutList;
  theModuleManager = 0;
}

Tvoid BtModuleManager::defineModule()
{
  // cc7700
  theCrateController = new TCamacCrateController( tPCIcc7700_1 );
  theCrateController -> SetCrateID( 0 );
  theCrateController -> Initialize();

  // CAMAC module
  theAdc = new TCamacAdcModule( theCrateController, BTadc_slot, BTadc_nch );
  theScaler = new TCamacScalerModule( theCrateController, BTscaler_slot, BTscaler_nch );
  theOutput = new TCamacOutputRegisterModule( theCrateController, BTor_slot );
  theCoincidence = new TCamacCoincidenceRegisterModule( theCrateController, BTcr_slot );
  theInterrupt = new TCamacInterruptRegisterModule( theCrateController, BTir_slot );

  // run info.
  TstringList itemlist;
  itemlist.clear();
  itemlist.push_back( "OPERATOR" );
  itemlist.push_back( "BEAM ENERGY" );
  itemlist.push_back( "RUN TYPE" );
  itemlist.push_back( "COMMENT" );

  TstringList valuelist;
  valuelist.clear();
  valuelist.push_back( "***" );
  valuelist.push_back( "***" );
  valuelist.push_back( "***" );
  valuelist.push_back( "***" );

  TRunInformationTable table( itemlist, valuelist );
  theRunInfo = new TSoftwareRunInformationModule( table, BTruninfo_id );

  // timer
  theTimer = new TSoftwareTimerModule( Tusec, BTtimer_nch, BTtimer_id );
  theClock = new TSoftwareClockModule( BTclock_nch, BTclock_id );

  // couter
  theRunNumber = new TSoftwareScalerModule( BTrunnum_nch, BTrunnum_id );
  theEventNumber = new TSoftwareScalerModule( BTevtnum_nch, BTevtnum_id );

  return;
}

Tvoid BtModuleManager::defineReadoutList()
{
  theRunBeginReadoutList = new TReadoutList( BTrunbegin );
  theRunEndReadoutList = new TReadoutList( BTrunend );
  theEventReadoutList = new TReadoutList( BTevent );
  theScalerEventReadoutList = new TReadoutList( BTscalerevent );

  // define run begin
  TReadoutSection sec0( 0x0000 );
  TReadoutSegment seg0( theRunNumber, 0x0000 );
  TReadoutSegment seg1( theRunInfo, 0x0001 );
  TReadoutSegment seg2( theClock, 0x0002 );
  TReadoutSegment seg3( theScaler, 0x0003 );
  sec0.push_back( seg0 );
  sec0.push_back( seg1 );
  sec0.push_back( seg2 );
  sec0.push_back( seg3 );
  theRunBeginReadoutList -> push_back( sec0 );


  // define run end
  TReadoutSection sec1( 0x0000 );
  TReadoutSegment seg4( theRunInfo, 0x0000 );
  TReadoutSegment seg5( theClock, 0x0001 );
  TReadoutSegment seg6( theScaler, 0x0002 );
  sec1.push_back( seg4 );
  sec1.push_back( seg5 );
  sec1.push_back( seg6 );
  theRunEndReadoutList -> push_back( sec1 );


  // event data
  TReadoutSection sec2( 0x0000 );
 // seg.ID: 0x0000, ele.ID: module ch.num.
  TReadoutSegment seg7( theEventNumber, 0x0000 );
  TReadoutSegment seg8( theAdc, 0x0001 );
  TReadoutSegment seg9( theCoincidence, 0x0002 );
  TReadoutSegment seg10( theTimer, 0x0003 ); //for study
  sec2.push_back( seg7 );
  sec2.push_back( seg8 );
  sec2.push_back( seg9 );
  sec2.push_back( seg10 );
  theEventReadoutList -> push_back( sec2 );


  // scaler event
  TReadoutSection sec3( 0x0000 );
  TReadoutSegment seg11( theEventNumber, 0x0000 );
  TReadoutSegment seg12( theScaler, 0x0001 );
  sec3.push_back( seg11 );
  sec3.push_back( seg12 );
  theScalerEventReadoutList -> push_back( sec3 );

  return;
}

Tvoid BtModuleManager::Update( const Tstring& updateid )
{
  if ( updateid == "csi" ) {
    theAdc -> Update();
    theCoincidence -> Update();
    theEventNumber -> Update();
    theInterrupt -> Update();
  } else if ( updateid == "scaler" ) {
    theScaler -> Update();
    theEventNumber -> Update();
    theInterrupt -> Update();
  }
  return;
}

Tvoid BtModuleManager::Initialize()
{
  theCrateController -> Initialize();
  theAdc -> Initialize();
  theCoincidence -> Initialize();
  theInterrupt -> Initialize();
  theRunNumber -> Initialize();
  theEventNumber -> Initialize();
  theScaler -> Initialize();
  theOutput -> Initialize();
  theTimer -> Initialize();
  theClock -> Initialize();
  return;
}
