// ============================================================================
//  $Id: BtRunAction.cc,v 1.5 2002/12/09 07:20:36 iwai Exp $
//  $Name:  $
// ============================================================================
#include "BtRunAction.hh"
#include "BtModuleManager.hh"
#include "BtRunSummary.hh"
#include "parameter.h"
#include "TOutputObjectFile.hh"
#include "TInputObjectFile.hh"
#include "TRun.hh"
#include "TDataRecord.hh"
#include "TReadoutList.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

BtRunAction::BtRunAction( BtModuleManager* manager )
  : theOutputFile( 0 ), theInputFile( 0 ), theModuleManager( manager ),
    theOutputHtml(), theRunSummary( 0 )
{;}

BtRunAction::~BtRunAction()
{;}

Tvoid BtRunAction::BeginOfRunAction( TRun& aRun )
{
  static const Tstring drecext = ".drec";
  static const Tstring htmlext = ".html";


  Tint runid = aRun.GetRunID();

  Tstring filename = "run";
  Tstring runidstr = aRun.GetRunIDofString();
  if ( runid < 10 ) {
    filename += "00";
  } else if ( runid < 100 ) {
    filename += "0";
  }

  static const Tstring htroot = "/home/beamtest";
  static const Tstring drecroot = "/datarecord/";
  static const Tstring htmlroot = "/runsummary/";

  Tstring drecfile = htroot + drecroot + filename + runidstr + drecext;
  Tstring htmlfile = htroot + htmlroot + filename + runidstr + htmlext;


  theOutputFile = new TOutputObjectFile( drecfile );
  Tcout << "event data outputs into " << drecfile << Tendl;
  theInputFile = new TInputObjectFile( drecfile );


  theModuleManager -> Initialize();
  theModuleManager -> SetRunNumber( aRun.GetRunID() );


  TDataRecord record =
    theModuleManager -> GetRunBeginReadoutList() -> ReadData();
  theOutputFile -> WriteData( record );

  theOutputHtml.Open( htmlfile );
  theRunSummary = new BtRunSummary();
  fillRunBeginInformation( record );

  return;
}

Tvoid BtRunAction::EndOfRunAction( TRun& aRun )
{
  TDataRecord record =
    theModuleManager -> GetRunEndReadoutList() -> ReadData();
  theOutputFile -> WriteData( record );


  fillRunEndInformation( record );
  fillHtmlFile();
  theOutputHtml.Close();

  delete theRunSummary;
  delete theOutputFile;
  delete theInputFile;
  theRunSummary = 0;
  theOutputFile = 0;
  theInputFile = 0;
  return;
}

Tvoid BtRunAction::FinalOfRunAction( TRun& aRun )
{
  Tcout << "final action is called, but nothing to do." << Tendl;
  Tcout << "process is going to terminate." << Tendl;
  return;
}

Tvoid BtRunAction::fillRunBeginInformation( const TDataRecord& record )
{
  TDataSection section = record[ 0 ];
  TDataSegment runnumber = section[ 0 ];
  TDataSegment date = section[ 2 ];

  theRunSummary -> SetRecordName( theOutputFile -> GetFileName() ); 
  theRunSummary -> SetRunID( *( (Tint*)(runnumber[ 0 ].GetData())) );
  theRunSummary -> SetRunBeginTime( *((Tstring*)(date[0].GetData())) );

  return;
}

Tvoid BtRunAction::fillRunEndInformation( const TDataRecord& record )
{
  TDataSection section = record[ 0 ];
  TDataSegment runinfo = section[ 0 ];
  TDataSegment date = section[ 1 ];

  TstringList itemlist;
  TstringList valuelist;
  for ( Tsize_t i = 0; i < runinfo.size(); i ++ ) {
    TDataElement element = runinfo[ i ];
    Tstring itembuf = ( (Tstring*)( element.GetData() ) )[ 0 ];
    Tstring valuebuf = ( (Tstring*)( element.GetData() ) )[ 1 ];
    itemlist.push_back( itembuf );
    valuelist.push_back( valuebuf );
  }
  TRunInformationTable table( itemlist, valuelist );

  theRunSummary -> SetRunInformationTable( table );
  theRunSummary -> SetRunEndTime( *((Tstring*)(date[0].GetData())) );
  theRunSummary -> SetRecordSize( theOutputFile -> GetTotalDataSize() );

  return;
}

Tvoid BtRunAction::fillHtmlFile()
{
  TRunInformationTable table = theRunSummary -> GenerateRunInformationTable();
  Tstring title = "Run Summary #";
  title += table.GetValue( "Run ID" );


  theOutputHtml << "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">" << Tendl;
  theOutputHtml << "<html>" << Tendl;
  theOutputHtml << "<head>" << Tendl;
  theOutputHtml << "<title>" << title << "</title>" << Tendl; //umeru
  theOutputHtml << "<meta http-equiv=\"content-type\" content=\"text/html; charset=euc-jp\">" << Tendl;
  theOutputHtml << "</head>" << Tendl;
  theOutputHtml << "<body>" << Tendl;
  theOutputHtml << "<h1>" << title << "</h1>" << Tendl;
  theOutputHtml << "<hr>" << Tendl;
  theOutputHtml << table << Tendl;
  theOutputHtml << "<hr>" << Tendl;
  theOutputHtml << "<div align=right>" << Tendl;
  /////////////////////////////////////////////////////////////////////////
  static const Tsize_t buflen = 256;
  static const Tstring format = "%Y/%m/%d %a %H:%M:%S %z %Z";
  Ttime_t time_now = 0;
  time( &time_now );
  struct tm* tm_now = localtime( &time_now );
  Tchar* s = new Tchar[ buflen ];
  strftime( s, buflen, format.c_str(), tm_now );
  Tstring dateinfo = s;
  delete [] s;
  /////////////////////////////////////////////////////////////////////////
  theOutputHtml << dateinfo << Tendl;
  theOutputHtml << "</div>" << Tendl;
  theOutputHtml << "</body>" << Tendl;
  theOutputHtml << "</html>" << Tendl;
  return;
}
