// ============================================================================
//  $Id: beamtest.cc,v 1.4 2002/12/09 07:20:36 iwai Exp $
//  $Name:  $
// ============================================================================
#include "BtDummyRunAction.hh"
#include "BtDummyEventAction.hh"
#include "BtDummyModuleManager.hh"
#include "BtRunAction.hh"
#include "BtEventAction.hh"
#include "BtModuleManager.hh"
#include "BtEventViewerCommand.hh"
#include "BtExtractorAdc.hh"
#include "BtExtractorScaler.hh"
#include "BtAnalysisAction.hh"

#include "TRunManager.hh"
#include "TAnalysisManager.hh"
#include "TTerminalUserInterface.hh"
#include "TRootAnalyser.hh"

int main( int argc, char** argv, char** envv )
{
  // start message, wait input.
  Tcout << "********************************************************************************" << Tendl;
  Tcout << "***** If you have a CAMAC module, type \"CAMAC\" and hit return.             *****" << Tendl;
  Tcout << "***** Note: You SHOULD adjust parameter.h header file.                     *****" << Tendl;
  Tcout << "***** If you do NOT have any CAMAC module, type \"DUMMY\" and hit return.    *****" << Tendl;
  Tcout << "***** Note: In this case, used alternate module in data taking.            *****" << Tendl;
  Tcout << "********************************************************************************" << Tendl << Tendl;
  Tcout << "enter, please: ";
  Tstring input;
  Tcin >> input;


  // define DAQ mode
  Tint mode;
  enum { CAMAC, SOFTWARE };
  if ( input[ 0 ] == 'C' || input[ 0 ] == 'c' ) {
    mode = CAMAC;
  } else if ( input[ 0 ] == 'D' || input[ 0 ] == 'd' ) {
    mode = SOFTWARE;
  } else {
    Tcerr << "unrecognised your input." << Tendl;
    Tcerr << "terminate this program, bye." << Tendl;
    return( -1 );
  }
  Tcout << endl << endl << endl << endl;


  TRunManager* manager = new TRunManager( new TTerminalUserInterface() );
  manager -> SetUserCommand( new BtEventViewerCommand( manager ) );
  //TAnalysisManager* analysis = new TAnalysisManager( new TRootAnalyser() );
  //analysis -> SetAnalysisAction( new BtAnalysisAction() );
  //analysis -> SetExtractor( new BtExtractorAdc() );
  //manager -> SetAnalysisManager( analysis );

  BtDummyModuleManager* dummymodule = 0;
  BtModuleManager* realmodule = 0;

  switch ( mode ) {

    case SOFTWARE:
      dummymodule = new BtDummyModuleManager();
      manager -> SetRunAction( new BtDummyRunAction( dummymodule ) );
      manager -> SetEventAction( new BtDummyEventAction( dummymodule ) );
      manager -> SetRunInformationModule( dummymodule -> GetRunInfo() );
      manager -> SessionStart();
      delete dummymodule;
      break;


    case CAMAC:
      realmodule = new BtModuleManager();
      manager -> SetRunAction( new BtRunAction( realmodule ) );
      manager -> SetEventAction( new BtEventAction( realmodule ) );
      manager -> SetRunInformationModule( realmodule -> GetRunInfo() );
      manager -> SessionStart();
      delete realmodule;
      break;

    default:
      break;
  }

  //delete analysis;
  delete manager;

  return( 0 );
}
