// ============================================================================
//  $Id: TRunStartCommand.cc,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TRunStartCommand.hh"
#include "TRunManager.hh"

static const Tstring name = "/run/start";
static const Tstring desc = "start a run.\nif you give a argument, set to run identification.\nhowever, it is omittable.\nexample> /run/start\nexample> /run/start 12345";

TRunStartCommand::TRunStartCommand( TRunManager* manager )
  : TCommand( manager, name, desc )
{;}

TRunStartCommand::~TRunStartCommand()
{;}

Tvoid TRunStartCommand::Execute( const TstringList& arguments )
{
  if ( !( arguments.empty() ) ) {
    if ( arguments.size() == 1 ) {
      Tstring runid = arguments[ 0 ];
      theRunManager -> StartRun( (Tint)( atoi( runid.c_str() ) ) );
      return;
    } else {
      ShowCommandDetail();
      return;
    }
  }

  theRunManager -> StartRun();

  return;
}
