// ============================================================================
//  $Id: TSleepCommand.cc,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TSleepCommand.hh"
#include "TRunManager.hh"

static const Tstring name = "/system/sleep";
static const Tstring desc = "sleep a parent process.\nsome thread processes go on.";

TSleepCommand::TSleepCommand( TRunManager* manager )
  : TCommand( manager, name, desc )
{;}

TSleepCommand::~TSleepCommand()
{;}

Tvoid TSleepCommand::Execute( const TstringList& arguments )
{
  //ޤưƤʤ
  //åɤߤޤäƤޤ
  if ( arguments.size() == 1 ) {
    Tpid_t parent = getpid();
    TUint timesec = (TUint)( atoi( arguments[ 0 ].c_str() ) );
    if ( fork() == 0 ) {
      sleep( timesec );
      exit( 0 );
    } else if ( getpid() == parent ) {
      wait( 0 );
    } else {
      return;
    }
  } else {
    ShowCommandDetail();
  }

  return;
}
