// ============================================================================
//  $Id: TDataElement.hh,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TDATAELEMENT_HH
#define __TDATAELEMENT_HH

#include "globals.h"
#include "TStreamableObject.hh"

class TOutputObjectStream;
class TOutputObjectFile;
class TOutputObjectSocket;
class TOutputObjectSharedMemory;

class TDataElement
  : public TStreamableObject
{

  private:
    Tvoid* theData;
    Telement_t theElementType;
    Tint theNumberOfPrimitives;

  public:
    TDataElement( Telement_t type = tTypeUnknown, const Tstring& id = TunknownID );
    TDataElement( Tvoid* data, Telement_t type, const Tstring& id = TunknownID, Tint ndata = 1 );
    TDataElement( const TDataElement& right );
    ~TDataElement();

  public:
    Tint WriteData( TOutputObjectStream* output );
    Tint GetDataSize();
    Tvoid FillData( Tvoid* data, Telement_t elementtype, Tint ndata = 1 );
    Tvoid FillData( Tvoid* data, Tint ndata = 1 );
    Tvoid Clear();

  public:
    Tvoid* GetData() const;
    Telement_t GetElementType() const;
    Tint GetNumberOfPrimitives() const;
    Tvoid SetData( Tvoid* data );
    Tvoid SetElementType( Telement_t elementtype );
    Tvoid SetNumberOfPrimitives( Tint nprimitives );

  public:
    const TDataElement& operator=( const TDataElement& right );
    Tbool operator==( const TDataElement& right ) const;
    Tbool operator!=( const TDataElement& right ) const;
    friend Tostream& operator<<( Tostream& tos, const TDataElement& right );

  private:
    Tvoid freeDataSpace();
    Tvoid allocateDataSpace( Tvoid* data );
    Tint writeToFile( TOutputObjectFile* ofile );
    Tint writeToSocket( TOutputObjectSocket* osocket );
    Tint writeToSharedMemory( TOutputObjectSharedMemory* omemory );

};

inline Tvoid TDataElement::FillData( Tvoid* data, Telement_t elementtype, Tint ndata )
{
  freeDataSpace();
  theElementType = elementtype;
  theNumberOfPrimitives = ndata;
  allocateDataSpace( data );
  return;
}

inline Tvoid TDataElement::FillData( Tvoid* data, Tint ndata )
{
  return( FillData( data, theElementType, ndata ) );
}

inline Tvoid* TDataElement::GetData() const
{
  return( theData );
}

inline Tvoid TDataElement::SetData( Tvoid* data )
{
  theData = data;
  return;
}

inline Telement_t TDataElement::GetElementType() const
{
  return( theElementType );
}

inline Tvoid TDataElement::SetElementType( Telement_t elementtype )
{
  theElementType = elementtype;
  return;
}

inline Tint TDataElement::GetNumberOfPrimitives() const
{
  return( theNumberOfPrimitives );
}

inline Tvoid TDataElement::SetNumberOfPrimitives( Tint nprimitives )
{
  theNumberOfPrimitives = nprimitives;
  return;
}

#endif
