// ============================================================================
//  $Id: TCamacAdcModule.cc,v 1.2 2002/12/08 13:27:53 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TCamacAdcModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TCamacAdcModule::TCamacAdcModule( TCamacCrateController* cc7x00, Tint slot, Tint nch, Tdata_t datalen )
  : TCamacModule( cc7x00, slot, nch, datalen )
{;}

TCamacAdcModule::TCamacAdcModule( const TCamacAdcModule& right )
  : TCamacModule( right )
{;}

TCamacAdcModule::~TCamacAdcModule()
{;}

const TCamacAdcModule& TCamacAdcModule::operator=( const TCamacAdcModule& right )
{
  *( (TCamacModule*)this ) = *( (TCamacModule*)(&right) );
  return( *this );
}

Tbool TCamacAdcModule::operator==( const TCamacAdcModule& right ) const
{
  return( *( (TCamacModule*)this ) == *( (TCamacModule*)(&right) ) );
}

Tbool TCamacAdcModule::operator!=( const TCamacAdcModule& right ) const
{
  return( *( (TCamacModule*)this ) != *( (TCamacModule*)(&right) ) );
}

Tvoid TCamacAdcModule::FillData( const TDataSegment& segment )
{
  for ( Tint i = 0; i < theNumberOfChannels; i ++ ) {
    Read( i );
    TDataElement element( &theCamacData, tTypeUnsignedInt, itostr( i ), 1 );
    ( (TDataElementList*)(&segment) ) -> push_back( element );
  }
  return;
}

Tvoid TCamacAdcModule::FillData( const TDataElement& element )
{
  Tint ch = atoi( element.GetID().c_str() );
  if ( ch < 0 || ch >= theNumberOfChannels ) {
    Tcerr << "TCamacAdcModule::FillData: invalid ID" << Tendl;
    ( (TDataElement*)(&element) ) -> FillData( &theStatus, tTypeInt, 1 );
  } else {
    Read( ch );
    ( (TDataElement*)(&element) ) -> FillData( &theCamacData, tTypeUnsignedInt, 1 );
  }
  return;
}
