// ============================================================================
//  $Id: TCamacCrateController.cc,v 1.2 2002/12/06 12:07:06 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TCamacCrateController.hh"

TCamacCrateController::TCamacCrateController()
  : theCrateControllerType( tCamacCrateControllerUnknown ), 
    theCrateID( -1 ), theFileDescriptor( -1 ), theStatus( -1 ),
    theISA7000( Tfalse )
{;}

TCamacCrateController::TCamacCrateController( TcamacCrateController_t cctype )
  : theCrateControllerType( cctype ), 
    theCrateID( -1 ), theFileDescriptor( -1 ), theStatus( -1 ),
    theISA7000( Tfalse )
{
  const Tstring head = "TCamacCrateController::TCamacCrateController: ";
  
  // open device file
  if ( !IsOpen() )
    Open();
  if ( theFileDescriptor < 0 ) {
    perror( head.c_str() );
    exit( theStatus );
  }

  // check the power
  if ( !IsOnline() ) {
    perror( head.c_str() );
    exit( theStatus );
  }

  theISA7000 |= ( theCrateControllerType == tISAcc7000_1 );
  theISA7000 |= ( theCrateControllerType == tISAcc7000_2 );
  theISA7000 |= ( theCrateControllerType == tISAcc7000_3 );
  theISA7000 |= ( theCrateControllerType == tISAcc7000_4 );
}

TCamacCrateController::~TCamacCrateController()
{
  if ( IsOpen() )
    Close();
}

Tvoid TCamacCrateController::Open()
{
  errno ^= errno;
  theFileDescriptor =
    open( ( TcamacDevices[ theCrateControllerType ] ).c_str(), O_RDWR );
  theStatus = -errno;
  return;
}

Tvoid TCamacCrateController::Close()
{
  errno ^= errno;
  close( theFileDescriptor );
  theFileDescriptor = -1;
  theStatus = -errno;
  return;
}

Tbool TCamacCrateController::IsOpen()
{
  if ( theFileDescriptor < 0 )
    return( Tfalse );
  return( Ttrue );
}

Tbool TCamacCrateController::IsOnline()
{
  errno ^= errno;
  Tint retval = ioctl( theFileDescriptor, IOC_TEST_ONLINE );
  theStatus = -errno;
  if ( retval < 0 )
    return( Tfalse );
  return( Ttrue );
}

Tvoid TCamacCrateController::Reset()
{
  errno ^= errno;
  ioctl( theFileDescriptor, IOC_RESET_CRATE );
  theStatus = -errno;
  return;
}

Tvoid TCamacCrateController::Initialize()
{
  errno ^= errno;
  ioctl( theFileDescriptor, IOC_SET_Z );
  theStatus = -errno;
  return;
}

Tvoid TCamacCrateController::Clear()
{
  errno ^= errno;
  ioctl( theFileDescriptor, IOC_SET_C );
  theStatus = -errno;
  return;
}

Tvoid TCamacCrateController::SetInhibition()
{
  errno ^= errno;
  ioctl( theFileDescriptor, IOC_SET_I );
  theStatus = -errno;
  return;
}

Tvoid TCamacCrateController::ReleaseInhibition()
{
  errno ^= errno;
  ioctl( theFileDescriptor, IOC_RESET_I );
  theStatus = -errno;
  return;
}

Tvoid TCamacCrateController::EnableInterrupt()
{
  errno ^= errno;
  ioctl( theFileDescriptor, IOC_SET_EI );
  theStatus = -errno;
  return;
}

Tvoid TCamacCrateController::DisableInterrupt()
{
  errno ^= errno;
  ioctl( theFileDescriptor, IOC_RESET_EI );
  theStatus = -errno;
  return;
}

Tvoid TCamacCrateController::SetCrateID( Tint crateid )
{
  errno ^= errno;
  ioctl( theFileDescriptor, IOC_SET_CN, crateid );
  theStatus = -errno;
  return;
}

Tvoid TCamacCrateController::SetCrateControllerType( TcamacCrateController_t type )
{
  theCrateControllerType = type;
  theISA7000 = Tfalse;
  theISA7000 |= ( theCrateControllerType == tISAcc7000_1 );
  theISA7000 |= ( theCrateControllerType == tISAcc7000_2 );
  theISA7000 |= ( theCrateControllerType == tISAcc7000_3 );
  theISA7000 |= ( theCrateControllerType == tISAcc7000_4 );
  return;
}
