// ============================================================================
//  $Id: TCamacSwitchRegisterModule.cc,v 1.2 2002/12/08 13:27:53 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TCamacSwitchRegisterModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TCamacSwitchRegisterModule::TCamacSwitchRegisterModule( TCamacCrateController* cc7x00, Tint slot, Tread_t target, Tint nch, Tdata_t datalen )
  : TCamacModule( cc7x00, slot, nch, datalen ), theReadTarget( target )
{;}

TCamacSwitchRegisterModule::TCamacSwitchRegisterModule( const TCamacSwitchRegisterModule& right )
  : TCamacModule( right ), theReadTarget( right.theReadTarget )
{;}

TCamacSwitchRegisterModule::~TCamacSwitchRegisterModule()
{;}

const TCamacSwitchRegisterModule& TCamacSwitchRegisterModule::operator=( const TCamacSwitchRegisterModule& right )
{
  *( (TCamacModule*)this ) = *( (TCamacModule*)(&right) );
  theReadTarget = right.theReadTarget;
  return( *this );
}

Tbool TCamacSwitchRegisterModule::operator==( const TCamacSwitchRegisterModule& right ) const
{
  Tbool retval = Ttrue;
  retval &= ( *( (TCamacModule*)this ) == *( (TCamacModule*)(&right) ) );
  retval &= ( theReadTarget == right.theReadTarget );
  return( retval );
}

Tbool TCamacSwitchRegisterModule::operator!=( const TCamacSwitchRegisterModule& right ) const
{
  Tbool retval = Tfalse;
  retval |= ( *( (TCamacModule*)this ) != *( (TCamacModule*)(&right) ) );
  retval |= ( theReadTarget != right.theReadTarget );
  return( retval );
}

Tvoid TCamacSwitchRegisterModule::FillData( const TDataSegment& segment )
{
  for ( Tint i = 0; i < theNumberOfChannels; i ++ ) {
    Read();
    TDataElement element( &theCamacData, tTypeUnsignedInt, itostr( i ), 1 );
    ( (TDataElementList*)(&segment) ) -> push_back( element );
  }
  return;
}

Tvoid TCamacSwitchRegisterModule::FillData( const TDataElement& element )
{
  Tint ch = atoi( element.GetID().c_str() );
  if ( ch < 0 || ch >= theNumberOfChannels ) {
    Tcerr << "TCamacSwitchRegisterModule::FillData: invalid ID" << Tendl;
    ( (TDataElement*)(&element) ) -> FillData( &theStatus, tTypeInt, 1 );
  } else {
    Read();
    ( (TDataElement*)(&element) ) -> FillData( &theCamacData, tTypeUnsignedInt, 1 );
  }
  return;
}

Tint TCamacSwitchRegisterModule::Read()
{
  Tint subaddress;
  if ( theReadTarget == tReadSwitch ) {
    subaddress = 1;
  } else if ( theReadTarget == tReadRegister ) {
    subaddress = 0;
  } else {
    Tstring head = "TCamacSwitchRegisterModule::Read(): ";
    Tcerr << head << "unknown target to read, register is read." << Tendl;
    subaddress = 0;
  }

  return( execute( subaddress, tCamacRead ) );
}
