// ============================================================================
//  $Id: TVmeMpx201aModule.cc,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TVmeMpx201aModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TVmeDaughterBoardMemoryModule.hh"

TVmeMpx201aModule::TVmeMpx201aModule( Toff_t offset, Tint nblock, Tint mapsize )
  : TVmeModule( 0, offset, mapsize, tA16D16 ), theMemoryModule( 0 )
{
  // block counter 1block=2048sample
  SetNumberOfBlock( nblock );

  // be variableness in future.
  SetOffsetAddressForDaughterBoard( 0xff00 );
  Toff_t daughteroffset = GetOffsetAddressForDaughterBoard();

  Tint nsamples = nblock * tBlock;
  Tint daughtersize = nsamples * 18;  // 16bit + 2bit(extra)

  theMemoryModule =
    new TVmeDaughterBoardMemoryModule( daughteroffset, daughtersize, nsamples );

}

TVmeMpx201aModule::TVmeMpx201aModule( const TVmeMpx201aModule& right )
  : TVmeModule( right ), theMemoryModule( 0 )
{
  Tint nblock = right.GetNumberOfBlock();
  SetNumberOfBlock( nblock );

  // be variableness in future.
  SetOffsetAddressForDaughterBoard( 0xff00 );
  Toff_t daughteroffset = GetOffsetAddressForDaughterBoard();

  Tint nsamples = nblock * tBlock;
  Tint daughtersize = nsamples * 18;  // 16bit + 2bit(extra)

  theMemoryModule =
    new TVmeDaughterBoardMemoryModule( daughteroffset, daughtersize, nsamples );
}

TVmeMpx201aModule::~TVmeMpx201aModule()
{
  static const Tstring head = "TVmeMpx201aModule::~TVmeMpx201aModule: ";
  if ( theMemoryModule ) {
    delete theMemoryModule;
    theMemoryModule = 0;
    Tcout << head << "Memory module was deleted." << Tendl;
  }
}

const TVmeMpx201aModule& TVmeMpx201aModule::operator=( const TVmeMpx201aModule& right )
{
  *( (TVmeModule*)this ) = *( (TVmeModule*)(&right) );

  Tint nblock = right.GetNumberOfBlock();
  SetNumberOfBlock( nblock );

  // be variableness in future.
  SetOffsetAddressForDaughterBoard( 0xff00 );
  Toff_t daughteroffset = GetOffsetAddressForDaughterBoard();

  Tint nsamples = nblock * tBlock;
  Tint daughtersize = nsamples * 18;  // 16bit + 2bit(extra)

  theMemoryModule =
    new TVmeDaughterBoardMemoryModule( daughteroffset, daughtersize, nsamples );

  return( *this );
}

Tbool TVmeMpx201aModule::operator==( const TVmeMpx201aModule& right ) const
{
  return( *( (TVmeModule*)this ) == *( (TVmeModule*)(&right) ) );
}

Tbool TVmeMpx201aModule::operator!=( const TVmeMpx201aModule& right ) const
{
  return( *( (TVmeModule*)this ) != *( (TVmeModule*)(&right) ) );
}

Tint TVmeMpx201aModule::Clear()
{
  theMemoryModule -> Clear();
  setBit( (TUshort*)( theBaseAddress + CONTROL_STATUS ), 4, 1 );
  setBit( (TUshort*)( theBaseAddress + CONTROL_STATUS ), 0, 0 );
  return( theStatus = tStatusSuccess );
}

Tint TVmeMpx201aModule::Update()
{
  return( Clear() );
}

Tint TVmeMpx201aModule::Initialize()
{
  return( Clear() );
}

Tvoid TVmeMpx201aModule::FillData( const TDataSegment& segment )
{
  theMemoryModule -> FillData( segment );
  return;
}

Tvoid TVmeMpx201aModule::FillData( const TDataElement& element )
{
  theMemoryModule -> FillData( element );
  return;
}

Tvoid TVmeMpx201aModule::SetEventSynchronisationMode( Tsync_t mode )
{
  switch ( mode ) {
    case tScannerMode:
      setBit( (TUshort*)( theBaseAddress + CONTROL_STATUS ), 7, 0 );
      break;
    case tInternalSynchronisationMode:
      setBit( (TUshort*)( theBaseAddress + CONTROL_STATUS ), 7, 1 );
      setBit( (TUshort*)( theBaseAddress + CONTROL_STATUS ), 6, 1 );
      break;
    case tExternalSynchronisationMode:
      setBit( (TUshort*)( theBaseAddress + CONTROL_STATUS ), 7, 1 );
      setBit( (TUshort*)( theBaseAddress + CONTROL_STATUS ), 6, 0 );
      break;
    default:
      Tcerr << "TVmeMpx201aModule::SetEventSynchronisationMode: invalid mode" << Tendl;
      break;
  }

  return;
}

Tvoid TVmeMpx201aModule::SetDataCaptureMode( TdataCapture_t mode )
{
  switch ( mode ) {
    case tTransientMode:
      setBit( (TUshort*)( theBaseAddress + CONTROL_STATUS ), 5, 1 );
      break;
    case tContinuousMode:
      setBit( (TUshort*)( theBaseAddress + CONTROL_STATUS ), 5, 0 );
      break;
    default:
      Tcerr << "TVmeMpx201aModule::SetDataCaptureMode: invalid mode" << Tendl;
      break;
  }
  return;
}

TVmeMpx201aModule::Tsync_t TVmeMpx201aModule::GetEventSynchronisationMode() const
{
  Tbit d07 = getBit( (TUshort*)( theBaseAddress + CONTROL_STATUS ), 7 );
  Tbit d06 = getBit( (TUshort*)( theBaseAddress + CONTROL_STATUS ), 6 );

  if ( d07 == 0 ) {
    return( tScannerMode );
  } else if ( d07 == 1 && d06 == 1 ) {
    return( tInternalSynchronisationMode );
  } else if ( d07 == 1 && d06 == 0 ) {
    return( tExternalSynchronisationMode );
  } else {
    return( tModeUnknown );
  }
}

Tvoid TVmeMpx201aModule::SetNumberOfBlock( Tint nblock )
{
  if ( nblock < 0 || nblock > 0x7fff ) {
    Tcerr << "TVmeMpx201aModule::SetNumberOfBlock: invalid number" << Tendl;
    return;
  }
  *( (Tshort*)( theBaseAddress + BLOCK_COUNT ) ) = (Tshort)nblock;
  return;
}

Tvoid TVmeMpx201aModule::SetSamplingRate( Tint nsample )
{
  if ( nsample < 0 || nsample > 0x00ff ) {
    Tcerr << "TVmeMpx201aModule::SetSamplingRate: invalid number" << Tendl;
    return;
  }
  *( (Tshort*)( theBaseAddress + SAMPLE_RATE ) ) = (Tshort)nsample;
  return;
}

Toff_t TVmeMpx201aModule::GetOffsetAddressForDaughterBoard() const
{
  Tshort regval = *( (Tshort*)( theBaseAddress + VME_OFFSET_ADDRESS ) );
  regval &= 0xff80;
  Toff_t retval = regval;
  retval = retval << 16;
  return( retval );
}

Tvoid TVmeMpx201aModule::SetOffsetAddressForDaughterBoard( Toff_t offset )
{
  // A31 to A23
  // 0x00800000 - 0xff800000
  //offset = offset & 0xff8
  //setBit( (TUshort*)( theBaseAddress + CONTROL_STATUS ), 0, 1 );
  // be variableness in future.
  *( (Tshort*)( theBaseAddress + VME_OFFSET_ADDRESS ) ) = (Tshort)offset;
  return;
}

Tvoid TVmeMpx201aModule::SetPage( Tint id )
{
  if ( id < 0 || id > 7 ) {
    Tcerr << "TVmeMpx201aModule::SetPage: invalid ID" << Tendl;
    return;
  }
  *( (Tshort*)( theBaseAddress + CONTROL_STATUS ) ) |= (Tshort)id;
  return;
}
