// ============================================================================
//  $Id: TVmeRpv130Module.cc,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TVmeRpv130Module.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TVmeRpv130Module::TVmeRpv130Module( Toff_t offset, Tint mapsize, Tint nch )
  : TVmeModule( nch, offset, mapsize, tA16D16 ),
    theReadoutMode( tReadoutWithThrough ), theLevelStatus( 0x0000 )
{
  LevelUp();
}

TVmeRpv130Module::TVmeRpv130Module( const TVmeRpv130Module& right )
  : TVmeModule( right ), 
    theReadoutMode( right.theReadoutMode ),
    theLevelStatus( right.theLevelStatus )
{;}

TVmeRpv130Module::~TVmeRpv130Module()
{;}

const TVmeRpv130Module& TVmeRpv130Module::operator=( const TVmeRpv130Module& right )
{
  *( (TVmeModule*)this ) = *( (TVmeModule*)(&right) );
  theReadoutMode = right.theReadoutMode;
  theLevelStatus = right.theLevelStatus;
  return( *this );
}

Tbool TVmeRpv130Module::operator==( const TVmeRpv130Module& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TVmeModule*)this ) == *( (TVmeModule*)(&right) ) );
  ret &= ( theReadoutMode == right.theReadoutMode );
  ret &= ( theLevelStatus == right.theLevelStatus );
  return( ret );
}

Tbool TVmeRpv130Module::operator!=( const TVmeRpv130Module& right ) const
{
  Tbool ret = Tfalse;
  ret |= ( *( (TVmeModule*)this ) != *( (TVmeModule*)(&right) ) );
  ret |= ( theReadoutMode != right.theReadoutMode );
  ret |= ( theLevelStatus != right.theLevelStatus );
  return( ret );
}

Tint TVmeRpv130Module::Clear()
{
  setBit( (TUshort*)( theBaseAddress + CSR1 ), 0, 1 );
  setBit( (TUshort*)( theBaseAddress + CSR1 ), 1, 1 );

  setBit( (TUshort*)( theBaseAddress + CSR2 ), 0, 1 );
  setBit( (TUshort*)( theBaseAddress + CSR2 ), 1, 1 );
  return( theStatus = tStatusSuccess );
}

Tint TVmeRpv130Module::Update()
{
  return( Clear() );
}

Tint TVmeRpv130Module::Initialize()
{
  Clear();
  Disable();
  return( theStatus = tStatusSuccess );
}

Tvoid TVmeRpv130Module::FillData( const TDataSegment& segment )
{
  for ( Tint i = 0; i < theNumberOfChannels; i ++ ) {
    TUshort data = Read( i );
    TDataElement element( &data, tTypeUnsignedShort, itostr( i ) );
    ( (TDataElementList*)(&segment) ) -> push_back( element );
  }
  return;
}

Tvoid TVmeRpv130Module::FillData( const TDataElement& element )
{
  Tint ch = atoi( element.GetID().c_str() );
  if ( ch < 0 || ch >= theNumberOfChannels ) {
    Tcerr << "TVmeRpv130Module::FillData: invalid ID" << Tendl;
    theStatus = -EFAULT;
    ( (TDataElement*)(&element) ) -> FillData( &theStatus, tTypeInt, 1 );
  } else {
    TUshort data = Read( ch );
    ( (TDataElement*)(&element) ) -> FillData( &data, tTypeUnsignedShort, 1 );
  }
  return;
}

Tvoid TVmeRpv130Module::Pulse()
{
  *( (TUshort*)( theBaseAddress + PULSE ) ) = 0x000ff;
  return;
}

Tvoid TVmeRpv130Module::Pulse( int channel )
{
  if ( channel < 0 || channel >= theNumberOfChannels ) {
    Tcerr << "TVmeRpv130Module::Pulse: invalid ID" << Tendl;
    return;
  }

  TUshort tmp = 0x0001;
  tmp = tmp << channel;
  tmp &= 0x00ff;
  *( (TUshort*)( theBaseAddress + PULSE ) ) = tmp;

  return;
}

Tvoid TVmeRpv130Module::LevelUp()
{
  *( (TUshort*)( theBaseAddress + LEVEL ) ) = 0x00000;
  theLevelStatus = 0x0000;
  return;
}

Tvoid TVmeRpv130Module::LevelUp( int channel )
{
  if ( channel < 0 || channel >= theNumberOfChannels ) {
    Tcerr << "TVmeRpv130Module::LevelUp: invalid ID" << Tendl;
    return;
  }

  setBit( (TUshort*)(&theLevelStatus), channel, 0 );
  *( (TUshort*)( theBaseAddress + LEVEL ) ) = theLevelStatus;

  return;
}

Tvoid TVmeRpv130Module::LevelDown()
{
  *( (TUshort*)( theBaseAddress + LEVEL ) ) = 0x000ff;
  theLevelStatus = 0x00ff;
  return;
}

Tvoid TVmeRpv130Module::LevelDown( int channel )
{
  if ( channel < 0 || channel >= theNumberOfChannels ) {
    Tcerr << "TVmeRpv130Module::LevelDown: invalid ID" << Tendl;
    return;
  }

  setBit( (TUshort*)(&theLevelStatus), channel, 1 );
  *( (TUshort*)( theBaseAddress + LEVEL ) ) = theLevelStatus;
  return;
}

Tvoid TVmeRpv130Module::Enable()
{
  setBit( (TUshort*)( theBaseAddress + CSR1 ), 4, 1 );
  setBit( (TUshort*)( theBaseAddress + CSR1 ), 6, 1 );

  setBit( (TUshort*)( theBaseAddress + CSR2 ), 4, 1 );
  setBit( (TUshort*)( theBaseAddress + CSR2 ), 6, 1 );
  return;
}

Tvoid TVmeRpv130Module::Disable()
{
  setBit( (TUshort*)( theBaseAddress + CSR1 ), 4, 0 );
  setBit( (TUshort*)( theBaseAddress + CSR1 ), 6, 0 );

  setBit( (TUshort*)( theBaseAddress + CSR2 ), 4, 0 );
  setBit( (TUshort*)( theBaseAddress + CSR2 ), 6, 0 );
  return;
}

TUshort TVmeRpv130Module::Read()
{
  TUshort data;
  switch ( theReadoutMode ) {
    case tReadoutWithLatch1:
      data = *( (TUshort*)( theBaseAddress + LATCH1 ) );
    case tReadoutWithLatch2:
      data = *( (TUshort*)( theBaseAddress + LATCH2 ) );
    case tReadoutWithRSFF:
      data = *( (TUshort*)( theBaseAddress + RSFF ) );
    case tReadoutWithThrough:
      data = *( (TUshort*)( theBaseAddress + THROUGH ) );
    default:
      data = *( (TUshort*)( theBaseAddress + RSFF ) );
  }
  data &= 0x00ff;
  return( data );
}

TUshort TVmeRpv130Module::Read( Tint channel )
{
  TUshort data;
  if ( channel < 0 || channel >= theNumberOfChannels ) {
    Tcerr << "TVmeRpv130Module::Read: invalid ID" << Tendl;
    theStatus = -EFAULT;
    data = EFAULT;
  } else {
    data = Read();
    data = data >> channel;
    data = data & 0x01;
  }
  return( data );
}
