// ============================================================================
//  $Id: TInputObjectSharedMemory.hh,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TINPUTOBJECTSHAREDMEMORY_HH
#define __TINPUTOBJECTSHAREDMEMORY_HH

#include "globals.h"
#include "TObjectSharedMemory.hh"
#include "TInputObjectStream.hh"

class TStreamableObject;
class TObjectFilter;
class TDataRecord;
class TDataSection;
class TDataSegment;
class TDataElement;

class TInputObjectSharedMemory
  : public TObjectSharedMemory, public TInputObjectStream
{

  private:
    Tbool theReadSuccessFlag;

  public:
    TInputObjectSharedMemory( Tint memsize = tDefaultMemorySize, Tint maxevt = tDefaultMaxEvent );
    TInputObjectSharedMemory( TObjectFilter* filter, Tint memsize = tDefaultMemorySize, Tint maxevt = tDefaultMaxEvent );
    ~TInputObjectSharedMemory();

  public:
    Tint ReadData( TStreamableObject& object );

  public:
    Tbool IsReadSuccess() const;

  private:
    TDataRecord getDataRecord();
    TDataSection getDataSection();
    TDataSegment getDataSegment();
    TDataElement getDataElement();
    Tvoid readProperties( Tobject_t& type, Tstring& id, Tsize_t& entries );
};

inline Tbool TInputObjectSharedMemory::IsReadSuccess() const
{
  return( theReadSuccessFlag );
}

#endif
