// ============================================================================
//  $Id: TObjectFile.hh,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TOBJECTFILE_HH
#define __TOBJECTFILE_HH

#include "globals.h"

class TObjectFile
{

  public:
    enum { 
      tSeekBegin = SEEK_SET, 
      tSeekCurrent = SEEK_CUR, 
      tSeekEnd = SEEK_END
    };

  protected:
    Tstring theFileName;
    Tstring theMode;
    TFileStream* theFileStream;

  public:
    TObjectFile( const Tstring& filename, const Tstring& mode );

  protected:
    virtual ~TObjectFile();

  public:
    const Tstring& GetFileName() const;
    const Tstring& GetMode() const;
    TFileStream* GetFileStream() const;

    Tvoid SetFileName( const Tstring& filename );
    Tvoid SetMode( const Tstring& mode );

  public:
    //inline const Tvoid* SetFileStream() const;
    Tvoid SetOffset( Tint offset, Tint whence = tSeekCurrent );
    Tint GetOffset();

};

inline const Tstring& TObjectFile::GetFileName() const
{ 
  return( theFileName );
}

inline const Tstring& TObjectFile::GetMode() const
{ 
  return( theMode );
}

inline TFileStream* TObjectFile::GetFileStream() const
{
  return( theFileStream );
}

inline Tvoid TObjectFile::SetFileName( const Tstring& filename )
{
  theFileName = filename;
  return;
}

inline Tvoid TObjectFile::SetMode( const Tstring& mode )
{
  // reopenʤƤ
  theMode = mode;
  return;
}

inline Tvoid TObjectFile::SetOffset( Tint offset, Tint whence )
{
  fseek( theFileStream, (Tlong)offset, whence );
  return;
}


inline Tint TObjectFile::GetOffset()
{
  return( (Tint)( ftell( theFileStream ) ) );
}

#endif
