// ============================================================================
//  $Id: TReadoutSegment.cc,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TReadoutSegment.hh"
#include "TDataSegment.hh"
#include "TModule.hh"

TReadoutSegment::TReadoutSegment(  const Tstring& id )
  : TReadoutDefinition( id ), TReadoutElementList(), theModule( 0 )
{;}

TReadoutSegment::TReadoutSegment( TModule* module, const Tstring& id )
  : TReadoutDefinition( id ), TReadoutElementList(), theModule( module )
{;}

TReadoutSegment::TReadoutSegment( const TReadoutSegment& right )
  : TReadoutDefinition( right ), TReadoutElementList( right ),
    theModule( right.theModule )
{;}

TReadoutSegment::~TReadoutSegment()
{;}

TDataSegment TReadoutSegment::ReadData()
{
  TDataSegment segment( theID );

  if ( theModule == 0 ) {
    for ( Tsize_t i = 0; i < size(); i ++ )
      segment.push_back( ( (*this)[ i ] ).ReadData() );
  } else {
    theModule -> FillData( segment );
  }

  return( segment );
}

const TReadoutSegment& TReadoutSegment::operator=( const TReadoutSegment& right )
{
  *( (TReadoutDefinition*)this ) = *( (TReadoutDefinition*)(&right) );
  *( (TReadoutElementList*)this ) = *( (TReadoutElementList*)(&right) );
  *theModule = *(right.theModule);
  return( *this );
}

Tbool TReadoutSegment::operator==( const TReadoutSegment& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TReadoutDefinition*)this ) == *( (TReadoutDefinition*)(&right) ) );
  ret &= ( *( (TReadoutElementList*)this ) == *( (TReadoutElementList*)(&right) ) );
  ret &= ( *theModule == *(right.theModule) );
  return( ret );
}

Tbool TReadoutSegment::operator!=( const TReadoutSegment& right ) const
{
  Tbool ret = Tfalse;
  ret |= ( *( (TReadoutDefinition*)this ) != *( (TReadoutDefinition*)(&right) ) );
  ret |= ( *( (TReadoutElementList*)this ) != *( (TReadoutElementList*)(&right) ) );
  ret |= ( *theModule != *(right.theModule) );
  return( ret );
}
