// ============================================================================
//  $Id: TRun.cc,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TRun.hh"
#include "TEventManager.hh"

TRun::TRun( Tint runid )
  : theRunID( runid ), theEventStack()
{
  theEventStack.clear();
}

TRun::TRun( const TEventStack& eventstack )
  : theRunID( 0 ), theEventStack( eventstack )
{;}

TRun::TRun( Tint runid, const TEventStack& eventstack )
  : theRunID( runid ), theEventStack( eventstack )
{;}

TRun::TRun( const TRun& right )
  : theRunID( right.theRunID ), theEventStack( right.theEventStack )
{;}

TRun::~TRun()
{;}

const TRun& TRun::operator=( const TRun& right )
{
  theRunID = right.theRunID;
  theEventStack = right.theEventStack;
  return( *this );
}

Tbool TRun::operator==( const TRun& right ) const
{
  if ( theRunID == right.theRunID && theEventStack == right.theEventStack )
    return( Ttrue );
  else
    return( Tfalse );
}

Tbool TRun::operator!=( const TRun& right ) const
{
  if ( theRunID != right.theRunID || theEventStack != right.theEventStack )
    return( Ttrue );
  else
    return( Tfalse );
}

Tvoid TRun::Clear()
{
  theEventStack.clear();
  TEventManager::GetEventManager() -> SetNumberOfEvents( 0 );
  return;
}

Tstring TRun::GetRunIDofString() const
{
  return( itostr( theRunID ) );
}
