// ============================================================================
//  $Id: fileOutput.cc,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TOutputObjectSharedMemory.hh"

TDataRecord create( Tint val );

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<nevent>" << Tendl;
    return( -1 );
  }
  const Tint nevent = atoi( argv[ 1 ] );
  TOutputObjectSharedMemory* omemory = new TOutputObjectSharedMemory();
  Tint datasize = 0;
  Tint nevents = 0;

  for ( Tint i = 0; i < nevent; i ++ ) {
    TDataRecord record = create( i );
    omemory -> WriteData( record );
    datasize += record.GetDataSize();
    nevents ++;
  }

  Tcout << nevents << " events, ";
  Tcout << datasize << Tslash << omemory -> GetTotalDataSize();
  Tcout << " byte data has been written." << Tendl;

  delete omemory;
  return( 0 );
}

TDataRecord create( Tint val )
{
  TDataRecord rec( "This is a Data Record." );
  TDataSection sec( "This is Data Section." );
  TDataSegment seg0( "This is a Data Segement identified 0." );
  TDataSegment seg1( "This is a Data Segement identified 1." );
  TDataSegment seg2( "This is a Data Segement identified 2." );

  Ttime_t time_now;
  Tint pasttime = (Tint)time( &time_now );
  struct tm* tm_now = localtime( &time_now );
  Tsize_t length = 64;
  Tchar* tmp = new Tchar[ length ];
  strftime( tmp, length,"%Y/%m/%d %H:%M:%S", tm_now );
  string tstr = tmp;
  delete [] tmp;
  const Tint nstrdata = 2;
  string strdata[ nstrdata ] = { 
    "ABCDEF ABCDEF ABCDEF ABCDEF END", 
    "abcefghijklmnopqrstuvwxyz abcefghijklmnopqrstuvwxyz end"
  };
  const Tint ndata = 1000;
  TUshort array[ ndata ];
  for ( TUshort i = 0; i < ndata; i ++ ) {
    array[ i ] = i + i;
  }
  
  seg0.push_back( TDataElement( &pasttime, tTypeInt, "This is a integer data(TIME).", 1 ) );
  seg0.push_back( TDataElement( &tstr, tTypeString, "This is a string data(TIME).", 1 ) );
  seg0.push_back( TDataElement( strdata, tTypeString, "This is a string array.", nstrdata ) );
  seg0.push_back( TDataElement( array, tTypeUnsignedShort, "This is unsigned short data array.", ndata ) );

  for ( Tint i = 0; i < 8; i ++ ) {
   Tint data = i + i * i + 0x1234 * val;
    seg1.push_back( TDataElement( &data, tTypeInt, itostr( i ) ) );
  }

  for ( Tdouble i = 0.0; i < 16.0; i ++ ) {
    Tdouble data = sin( i * i * val + val );
    seg2.push_back( TDataElement( &data, tTypeDouble, dtostr( i ) ) );
  }

  sec.push_back( seg0 );
  sec.push_back( seg1 );
  sec.push_back( seg2 );
  rec.push_back( sec );

  return( rec );
}
