// ============================================================================
//  $Id: BtCrateDefinition.cc,v 1.1.1.1 2002/12/04 23:47:38 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TCrate.hh"
#include "TSoftwareScalerModule.hh"
#include "TSoftwareTimerModule.hh"
#include "TSoftwareClockModule.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TRunInformationTable.hh"
#include "TCamacCrateController.hh"
#include "TCamacAdcModule.hh"
#include "TCamacScalerModule.hh"
#include "TCamacInterruptRegisterModule.hh"
#include "TCamacOutputRegisterModule.hh"
#include "TCamacCoincidenceRegisterModule.hh"

#include "BtCrateDefinition.hh"

BtCrateDefinition::BtCrateDefinition()
  : TCrateDefinition()
{;}

BtCrateDefinition::~BtCrateDefinition()
{;}

TCrate* BtCrateDefinition::Define()
{
  TstringList itemlist;
  itemlist.clear();
  itemlist.push_back( "OPERATOR" );
  itemlist.push_back( "BEAM ENERGY" );
  itemlist.push_back( "RUN TYPE" );
  itemlist.push_back( "COMMENT" );
  TstringList valuelist;
  valuelist.clear();
  valuelist.push_back( "***" );
  valuelist.push_back( "***" );
  valuelist.push_back( "***" );
  valuelist.push_back( "***" );
  TRunInformationTable table = TRunInformationTable( itemlist, valuelist );

  TCrate* crate = new TCrate();

  // CC7700
  TCamacCrateController* cc7700 = new TCamacCrateController( tPCIcc7700_1 );
  cc7700 -> SetCrateID( 0 );
  cc7700 -> Initialize();

  // CAMAC module
  const Tint adcslot = 1;
  TCamacAdcModule* adc = new TCamacAdcModule( cc7700, adcslot, 1 );
  TstringList groups;
  groups.push_back( "run begin" );
  groups.push_back( "csi event" );
  crate -> AddModule( adc, "ADC", groups );

  const Tint scalerslot = 7;
  TCamacScalerModule* scaler = new TCamacScalerModule( cc7700, scalerslot, 8 );
  groups.clear();
  groups.push_back( "run begin" );
  groups.push_back( "scaler event" );
  crate -> AddModule( scaler, "Scaler", groups );

  const Tint orslot = 21;
  TCamacOutputRegisterModule* org = new TCamacOutputRegisterModule( cc7700, orslot );
  groups.clear();
  groups.push_back( "run begin" );
  crate -> AddModule( org, "Output Register", groups );

  const Tint crslot = 13;
  TCamacCoincidenceRegisterModule* cr = new TCamacCoincidenceRegisterModule( cc7700, crslot );
  groups.clear();
  groups.push_back( "run begin" );
  groups.push_back( "csi event" );
  crate -> AddModule( cr, "Coincidence Register", groups );

  const Tint irslot = 22;
  TCamacInterruptRegisterModule* ir = new TCamacInterruptRegisterModule( cc7700, irslot );
  groups.clear();
  groups.push_back( "run begin" );
  groups.push_back( "csi event" );
  groups.push_back( "scaler event" );
  crate -> AddModule( ir, "Interrupt Register", groups );


  // software module
  TSoftwareRunInformationModule* runinfo = new TSoftwareRunInformationModule( table );
  crate -> AddModule( runinfo, "Run Information" );

  TSoftwareTimerModule* timer = new TSoftwareTimerModule( Tusec, 1 );
  groups.clear();
  groups.push_back( "run begin" );
  crate -> AddModule( timer, "Timer", groups );

  TSoftwareClockModule* clock = new TSoftwareClockModule( 1 );
  groups.clear();
  groups.push_back( "run begin" );
  crate -> AddModule( clock, "Clock", groups );

  TSoftwareScalerModule* runnumber = new TSoftwareScalerModule( 1 );
  groups.clear();
  groups.push_back( "run begin" );
  crate -> AddModule( runnumber, "Run ID", groups );

  TSoftwareScalerModule* evtnumber = new TSoftwareScalerModule( 1 );
  groups.clear();
  groups.push_back( "run begin" );
  groups.push_back( "csi event" );
  groups.push_back( "scaler event" );
  crate -> AddModule( evtnumber, "Event ID", groups );

  return( crate );
}
