// ============================================================================
//  $Id: BtRunAction.hh,v 1.5 2002/12/09 07:20:36 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __BTRUNACTION_HH
#define __BTRUNACTION_HH

#include "TRunAction.hh"
#include "TOutputHtmlFileStream.hh"

class TRun;
class TOutputObjectFile;
class TInputObjectFile;
class TDataRecord;
class BtRunSummary;

class BtRunAction
  : public TRunAction
{

  private:
    TOutputObjectFile* theOutputFile;
    BtRunSummary* theRunSummary;
    TOutputHtmlFileStream theOutputHtml;

  public:
    BtRunAction();
    ~BtRunAction();

  public:
    Tvoid BeginOfRunAction( TRun& aRun );
    Tvoid EndOfRunAction( TRun& aRun );
    Tvoid FinalOfRunAction( TRun& aRun );

  public:
    TOutputObjectFile* GetOutputFile() const;
    BtRunSummary* GetRunSummary() const;
    TOutputHtmlFileStream& GetOutputHtml();

  private:
    Tvoid fillRunBeginInformation( const TDataRecord& record );
    Tvoid fillRunEndInformation( const TDataRecord& record );
    Tvoid fillHtmlFile();

};

inline TOutputObjectFile* BtRunAction::GetOutputFile() const
{
  return( theOutputFile );
}

inline BtRunSummary* BtRunAction::GetRunSummary() const
{
  return( theRunSummary );
}

inline TOutputHtmlFileStream& BtRunAction::GetOutputHtml()
{
  return( theOutputHtml );
}

#endif
