// ============================================================================
//  $Id: DummyGeant4ViewCommand.cc,v 1.1 2002/12/09 07:20:36 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TRunManager.hh"
#include "TUserInterface.hh"
#include "TOutputObjectFile.hh"

#include "DummyGeant4ViewCommand.hh"
#include "DummyRunAction.hh"

static const Tstring name = "/local/geant4view";
static const Tstring desc = "view histogram(Geant4)";

DummyGeant4ViewCommand::DummyGeant4ViewCommand( TRunManager* manager )
  : TCommand( manager, name, desc )
{;}

DummyGeant4ViewCommand::~DummyGeant4ViewCommand()
{;}

Tvoid DummyGeant4ViewCommand::Execute( const TstringList& arguments )
{
  TUserInterface* ui = theRunManager -> GetUserInterface();
  DummyRunAction* action = (DummyRunAction*)( theRunManager -> GetRunAction() );
  Tstring filename = action -> GetOutputFile() -> GetFileName();
  Tstring com = "/system/shell";
  TstringList args;
  args.push_back( "./../../bin/geant4view" );
  args.push_back( filename );
  args.push_back( "&" );

  ui -> ExecuteCommand( com, args );

  return;
}
