// ============================================================================
//  $Id: dummydaq.cc,v 1.2 2002/12/07 13:13:49 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TRunManager.hh"
#include "TTerminalUserInterface.hh"
#include "TCrate.hh"

#include "DummyRunAction.hh"
#include "DummyEventAction.hh"
#include "DummyCrateDefinition.hh"
#include "DummyReadoutBookDefinition.hh"
#include "DummyAdcViewCommand.hh"
#include "DummyFlashAdcViewCommand.hh"
#include "DummyGeant4ViewCommand.hh"

int main( int argc, char** argv, char** envv )
{
  TRunManager* manager = new TRunManager( new TTerminalUserInterface() );

  manager -> SetRunAction( new DummyRunAction() );
  manager -> SetEventAction( new DummyEventAction() );
  manager -> SetCrateDefinition( new DummyCrateDefinition() );
  manager -> SetReadoutBookDefinition( new DummyReadoutBookDefinition() );


  TCrate* crate = manager -> GetCrate();
  TSoftwareRunInformationModule* runinfo =
    (TSoftwareRunInformationModule*)( crate -> GetModule( "Run Information" ) );
  manager -> SetRunInformationModule( runinfo );


  manager -> SetUserCommand( new DummyAdcViewCommand( manager ) );
  manager -> SetUserCommand( new DummyFlashAdcViewCommand( manager ) );
  manager -> SetUserCommand( new DummyGeant4ViewCommand( manager ) );


  manager -> SessionStart();

  delete manager;
  return( 0 );
}
