// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TPrintCurrentWorkingDirectoryCommand.hh"
#include "TRunManager.hh"
#include "TUserInterface.hh"

static const Tstring name = "pwd";
static const Tstring desc = "print the absolute pathname of the current working directory.";

TPrintCurrentWorkingDirectoryCommand::TPrintCurrentWorkingDirectoryCommand( TRunManager* manager )
  : TCommand( manager, name, desc )
{;}

TPrintCurrentWorkingDirectoryCommand::~TPrintCurrentWorkingDirectoryCommand()
{;}

Tvoid TPrintCurrentWorkingDirectoryCommand::Execute( const TstringList& arguments )
{
  TUserInterface* ui = theRunManager -> GetUserInterface();
  static const Tstring head = "TPrintCurrentWorkingDirectoryCommand::Execute: ";
  if ( ui ) {
    Tcout << ui -> GetCurrentWorkingDirectory() << Tendl;
  } else {
    Tcerr << head << "UserInterface doesn't exist." << Tendl;
  }
  return;
}
