// ============================================================================
//  $Id: TDataSegment.hh,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TDATASEGMENT_HH
#define __TDATASEGMENT_HH

#include "Tglobals.h"
#include "TStreamableObject.hh"
#include "TDataElementList.hh"

class TOutputObjectStream;
class TOutputObjectFile;
class TOutputObjectSocket;
class TOutputObjectSharedMemory;

class TDataSegment
  : public TStreamableObject, public TDataElementList
{

  public:
    TDataSegment( const Tstring& id = TunknownID );
    TDataSegment( const TDataSegment& right );
    ~TDataSegment();

  public:
    Tint GetDataSize();
    Tint WriteData( TOutputObjectStream* output );
    Tvoid Clear();

  public:
    const TDataSegment& operator=( const TDataSegment& right );
    Tbool operator==( const TDataSegment& right ) const;
    Tbool operator!=( const TDataSegment& right ) const;
    friend Tostream& operator<<( Tostream& tos, const TDataSegment& right );

  public:
    Tbool FindDataElement( const Tstring& id, TDataElement& element ) const;
    Tint FindDataElement( const Tstring& id ) const;

  private:
    Tint writeToFile( TOutputObjectFile* ofile );
    Tint writeToSocket( TOutputObjectSocket* osocket );
    Tint writeToSharedMemory( TOutputObjectSharedMemory* omemory );


};

#endif
