// ============================================================================
//  $Id: TEventAction.hh,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TEVENTACTION_HH
#define __TEVENTACTION_HH

#include "Tglobals.h"

class TEvent;
class TReadoutList;
class TRunManager;
class TEventManager;
class TReadoutBook;
class TCrate;

class TEventAction
{

  protected:
    TRunManager* theRunManager;
    TEventManager* theEventManager;
    TReadoutBook* theReadoutBook;
    TCrate* theCrate;

  public:
    TEventAction();
    virtual ~TEventAction();

  public:
    virtual TReadoutList* WaitEvent() = 0;

  public:
    virtual Tvoid BeginOfEventAction( TEvent& anEvent );
    virtual Tvoid EndOfEventAction( TEvent& anEvent );

  public:
    TRunManager* GetRunManager() const;
    TEventManager* GetEventManager() const;
    TReadoutBook* GetReadoutBook() const;
    TCrate* GetCrate() const;
    Tvoid SetRunManager( TRunManager* manager );
    Tvoid SetEventManager( TEventManager* manager );
    Tvoid SetReadoutBook( TReadoutBook* book );
    Tvoid SetCrate( TCrate* crate );

};

inline TRunManager* TEventAction::GetRunManager() const
{
  return( theRunManager );
}

inline TEventManager* TEventAction::GetEventManager() const
{
  return( theEventManager );
}

inline TReadoutBook* TEventAction::GetReadoutBook() const
{
  return( theReadoutBook );
}

inline TCrate* TEventAction::GetCrate() const
{
  return( theCrate );
}

inline Tvoid TEventAction::SetRunManager( TRunManager* manager )
{
  theRunManager = manager;
  return;
}

inline Tvoid TEventAction::SetEventManager( TEventManager* manager )
{
  theEventManager = manager;
  return;
}

inline Tvoid TEventAction::SetReadoutBook( TReadoutBook* book )
{
  theReadoutBook = book;
  return;
}

inline Tvoid TEventAction::SetCrate( TCrate* crate )
{
  theCrate = crate;
  return;
}

#endif
