// ============================================================================
//  $Id: TCamacOutputRegisterModule.cc,v 1.2 2002/12/08 13:27:53 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TCamacOutputRegisterModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TCamacOutputRegisterModule::TCamacOutputRegisterModule( TCamacCrateController* cc7x00, Tint slot, Tdata_t datalen )
  : TCamacModule( cc7x00, slot, 0, datalen )
{;}

TCamacOutputRegisterModule::TCamacOutputRegisterModule( const TCamacOutputRegisterModule& right )
  : TCamacModule( right )
{;}

TCamacOutputRegisterModule::~TCamacOutputRegisterModule()
{;}

const TCamacOutputRegisterModule& TCamacOutputRegisterModule::operator=( const TCamacOutputRegisterModule& right )
{
  *( (TCamacModule*)this ) = *( (TCamacModule*)(&right) );
  return( *this );
}

Tbool TCamacOutputRegisterModule::operator==( const TCamacOutputRegisterModule& right ) const
{
  return( *( (TCamacModule*)this ) == *( (TCamacModule*)(&right) ) );
}

Tbool TCamacOutputRegisterModule::operator!=( const TCamacOutputRegisterModule& right ) const
{
  return( *( (TCamacModule*)this ) != *( (TCamacModule*)(&right) ) );
}

Tvoid TCamacOutputRegisterModule::FillData( TDataElement& element, Tint channel )
{
  return;
}

Tint TCamacOutputRegisterModule::Pulse( Tint data )
{
  theCamacData = data;
  return( execute( 0, 17 ) );
}

Tint TCamacOutputRegisterModule::Level( Tint data )
{
  theCamacData = data;
  return( execute( 0, tCamacWrite ) );
}
