// ============================================================================
//  $Id: TCamacSwitchRegisterModule.cc,v 1.2 2002/12/08 13:27:53 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TCamacSwitchRegisterModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TCamacSwitchRegisterModule::TCamacSwitchRegisterModule( TCamacCrateController* cc7x00, Tint slot, Tint nch, Tdata_t datalen )
  : TCamacModule( cc7x00, slot, nch, datalen )
{;}

TCamacSwitchRegisterModule::TCamacSwitchRegisterModule( const TCamacSwitchRegisterModule& right )
  : TCamacModule( right )
{;}

TCamacSwitchRegisterModule::~TCamacSwitchRegisterModule()
{;}

const TCamacSwitchRegisterModule& TCamacSwitchRegisterModule::operator=( const TCamacSwitchRegisterModule& right )
{
  *( (TCamacModule*)this ) = *( (TCamacModule*)(&right) );
  return( *this );
}

Tbool TCamacSwitchRegisterModule::operator==( const TCamacSwitchRegisterModule& right ) const
{
  return( *( (TCamacModule*)this ) == *( (TCamacModule*)(&right) ) );
}

Tbool TCamacSwitchRegisterModule::operator!=( const TCamacSwitchRegisterModule& right ) const
{
  return( *( (TCamacModule*)this ) != *( (TCamacModule*)(&right) ) );
}

Tvoid TCamacSwitchRegisterModule::FillData( TDataElement& element, Tint channel )
{
  if ( channel < 0 || channel >= theNumberOfChannels ) {
    Tcerr << "TCamacSwitchRegisterModule::FillData: invalid ID " << channel << Tendl;
    element.FillData( &theStatus, tTypeInt, 1 );
  } else {
    Read( channel );
    element.FillData( &theCamacData, tTypeUnsignedInt, 1 );
  }
  return;
}
