// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TCRATE_HH
#define __TCRATE_HH

#include "Tglobals.h"
#include "TModuleSpecifiedTable.hh"

class TModule;
class TCamacCrateController;

class TCrate
{

  private:
    TModule** theModuleList;
    TModuleSpecifiedTable theModuleSpecifiedTable;
    Tint theModuleListCapacity;
    Tint theNumberOfModules;
    Tint theModuleIndex;
    TCamacCrateController* theCamacCrateController;

  public:
    TCrate();
    ~TCrate();

  public:
    Tint AddModule( TModule* module, const Tstring& id, const TstringList& group );
    Tint AddModule( TModule* module, const Tstring& id, const Tstring& group = "" );
    Tint RemoveModule( Tint index );
    Tint RemoveModule( const Tstring& id );
    Tint RemoveModule( const TstringList& groups );
    Tvoid ClearModuleList();
    Tbool ResizeModuleList( Tint capacity );
    TModule* NextModule();
    TModule* FindModule( const Tstring& id );
    TModule* GetModule( Tint index );
    TModule* GetModule( const Tstring& id );
    TModule* GetModule();

  private:
    Tvoid free();
    Tvoid allocate( Tint capacity );

  public:
    const TModuleSpecifiedTable& GetModuleSpecifiedTable() const;
    TModuleSpecifiedTable& GetModuleSpecifiedTable();
    Tint GetModuleListCapacity() const;
    Tint GetNumberOfModules() const;
    Tint GetModuleIndex() const;
    Tvoid SetModuleSpecifiedTable( const TModuleSpecifiedTable& table );
    Tvoid SetModuleIndex( Tint index );

  public:
    const TCamacCrateController* GetCamacCrateController() const;
    TCamacCrateController* GetCamacCrateController();
    Tvoid InstallCamacCrateController( TCamacCrateController* cratectl );
    Tvoid RemoveCamacCrateController();

  public:
    Tvoid Clear( const TstringList& groups );
    Tvoid Clear( const Tstring& group );
    Tvoid Update( const TstringList& groups );
    Tvoid Update( const Tstring& group );
    Tvoid Initialize( const TstringList& groups );
    Tvoid Initialize( const Tstring& group );
    Tvoid ClearAllModules();
    Tvoid UpdateAllModules();
    Tvoid InitializeAllModules();
    Tvoid ClearModule( const Tstring& id );
    Tvoid UpdateModule( const Tstring& id );
    Tvoid InitializeModule( const Tstring& id );

};

inline const TModuleSpecifiedTable& TCrate::GetModuleSpecifiedTable() const
{
  return( theModuleSpecifiedTable );
}

inline TModuleSpecifiedTable& TCrate::GetModuleSpecifiedTable()
{
  return( theModuleSpecifiedTable );
}

inline Tint TCrate::GetModuleListCapacity() const
{
  return( theModuleListCapacity );
}

inline Tint TCrate::GetNumberOfModules() const
{
  return( theNumberOfModules );
}

inline Tint TCrate::GetModuleIndex() const
{
  return( theModuleIndex );
}

inline Tvoid TCrate::SetModuleSpecifiedTable( const TModuleSpecifiedTable& table )
{
  theModuleSpecifiedTable = table;
  return;
}

inline Tvoid TCrate::SetModuleIndex( Tint index )
{
  theModuleIndex = index;
  return;
}

inline const TCamacCrateController* TCrate::GetCamacCrateController() const
{
  return( theCamacCrateController );
}

inline TCamacCrateController* TCrate::GetCamacCrateController()
{
  return( theCamacCrateController );
}

#endif
