// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TMODULESPECIFIED_HH
#define __TMODULESPECIFIED_HH

#include "Tglobals.h"

class TModuleSpecified
{

  private:
    Tint theModuleIndex;
    Tstring theModuleID;
    TstringList theGroupIDs;

  public:
    TModuleSpecified();
    TModuleSpecified( Tint index, const Tstring& id, const TstringList& groups );
    TModuleSpecified( const TModuleSpecified& right );
    ~TModuleSpecified();

  public:
    const TModuleSpecified& operator=( const TModuleSpecified& right );
    Tbool operator==( const TModuleSpecified& right ) const;
    Tbool operator!=( const TModuleSpecified& right ) const;
    friend Tostream& operator<<( Tostream& tos, const TModuleSpecified& right );

  public:
    Tint GetModuleIndex() const;
    const Tstring& GetModuleID() const;
    Tstring& GetModuleID();
    const TstringList& GetGroupIDs() const;
    TstringList& GetGroupIDs();
    Tvoid SetModuleIndex( Tint index );
    Tvoid SetModuleID( const Tstring& id );
    Tvoid SetGroupIDs( const TstringList& ids );
    Tbool IsSameGroup( const TModuleSpecified& spec );
    Tbool IsSameGroup( const TstringList& groups );
    Tbool IsSameGroup( const Tstring& group );

};

inline Tint TModuleSpecified::GetModuleIndex() const
{
  return( theModuleIndex );
}

inline const Tstring& TModuleSpecified::GetModuleID() const
{
  return( theModuleID );
}

inline Tstring& TModuleSpecified::GetModuleID()
{
  return( theModuleID );
}

inline const TstringList& TModuleSpecified::GetGroupIDs() const
{
  return( theGroupIDs );
}

inline TstringList& TModuleSpecified::GetGroupIDs()
{
  return( theGroupIDs );
}

inline Tvoid TModuleSpecified::SetModuleIndex( Tint index )
{
  theModuleIndex = index;
  return;
}

inline Tvoid TModuleSpecified::SetModuleID( const Tstring& id )
{
  theModuleID = id;
  return;
}

inline Tvoid TModuleSpecified::SetGroupIDs( const TstringList& ids )
{
  theGroupIDs = ids;
  return;
}

#endif
