// ============================================================================
//  $Id: fileInput.cc,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TDataRecord.hh"
#include "TInputObjectFile.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<filename>" << Tendl;
    return( -1 );
  }
  const Tstring filename = argv[ 1 ];
  TInputObjectFile ifile = TInputObjectFile( filename );
  Tint nevents = 0;
  Tint datasize = 0;

  TDataRecord record;
  while ( ( ifile >> record ) != 0 ) {
    Tcout << record << Tendl;
    datasize += record.GetDataSize();
    nevents ++;
  }

  Tcout << nevents << " events, ";
  Tcout << datasize << Tslash << ifile.GetTotalDataSize();
  Tcout << " byte data has been read from " << filename << "." << Tendl;

  return( 0 );
}
