// ============================================================================
//  $Id: fadcview.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include <TROOT.h>
#include <TSystem.h>
#include <TApplication.h> 
#include <TStyle.h>
#include <TGraph.h>
#include <TH1.h>
#include <TH2.h>
#include <TCanvas.h>
#include <TNtuple.h>
#include <TFile.h>
#include <TPad.h>

#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<filename>" << Tendl;
    return( -1 );
  }

  TApplication* theApp = new TApplication( "root-analyser", 0, 0 );
  gROOT -> Reset( 0 );

  Tstring filename = argv[ 1 ];
  TInputObjectFile ifile = TInputObjectFile( filename );


  TCanvas canvas( "adc", "Flash ADC", 800, 600 );
  gPad -> SetGrid();

  TGraph fadc( 62500 );
  fadc.SetTitle( "Flash ADC" );
  fadc.SetMarkerColor( 2 );

  Tstring idset[ 3 ] = { "Event Data", "Flash ADC" };
  TDataRecord record;

  while ( 1 ) {

    Tint datasize = ifile >> record;
    if ( datasize == 0 ) {
      ifile.SetOffset( ifile.GetTotalDataSize(), SEEK_SET );
      sleep( 1 );
      continue;
    }

    Tstring recid = record.GetID();


    if ( recid == "RUN BEGIN" ) {
      continue;
    } else if ( recid == "RUN END" ) {
      break;
    } else if ( recid == "EVENT" ) {

      TDataSegment segment;
      record.FindDataSegment( idset, segment );

      TDataElement element = segment[ 0 ];
      TUshort* data = element.GetUnsignedShortData();
      Tint nprimitives = element.GetNumberOfPrimitives();
      for ( Tint i = 0; i < nprimitives; i ++ ) {
	fadc.SetPoint( i, (Tdouble)i, (Tdouble)data[ i ] );
      }

      fadc.Draw( "ap" );
      canvas.Modified();
      canvas.Update();

    } else {
      break;
    }

    gSystem -> ProcessEvents();

  }

  theApp -> Run();

  return( 0 );
}
