// ============================================================================
//  $Id: geant4view.cc,v 1.2 2003/01/20 11:14:11 iwai Exp $
//  $Name:  $
// ============================================================================
#include <TROOT.h>
#include <TSystem.h>
#include <TApplication.h> 
#include <TStyle.h>
#include <TGraph.h>
#include <TH1.h>
#include <TH2.h>
#include <TCanvas.h>
#include <TNtuple.h>
#include <TFile.h>
#include <TPad.h>

#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<filename>" << Tendl;
    return( -1 );
  }

  TApplication* theApp = new TApplication( "root-analyser", 0, 0 );
  gROOT -> Reset( 0 );

  Tstring filename = argv[ 1 ];
  TInputObjectFile ifile = TInputObjectFile( filename );


  TCanvas canvas( "simmodule", "Geant4 View", 640, 480 );
  gPad -> SetGrid();
  gStyle -> SetOptStat( 1111111 );

  TH1D g4hist = TH1D( "Beamenergyspectrum", "Beam energy spectrum", 6, 0, 6 );

  Tstring idset[ 3 ] = { "Event Data", "Geant4" };
  TDataRecord record;

  while ( 1 ) {

    Tint datasize = ifile >> record;
    if ( datasize == 0 ) {
      ifile.SetOffset( ifile.GetTotalDataSize(), SEEK_SET );
      sleep( 1 );
      continue;
    }

    Tstring recid = record.GetID();


    if ( recid == "RUN BEGIN" ) {
      continue;
    } else if ( recid == "RUN END" ) {
      break;
    } else if ( recid == "EVENT" ) {

      TDataSegment segment;
      record.FindDataSegment( idset, segment );

      TDataElement ccdid = segment[ 0 ];
      TDataElement edep = segment[ 1 ];

      Tdouble id = *( ccdid.GetDoubleData() );
      Tdouble e = *( edep.GetDoubleData() );

      g4hist.Fill( id, e );
      g4hist.Draw();
      canvas.Modified();
      canvas.Update();      

    } else {
      break;
    }

    gSystem -> ProcessEvents();

  }

  theApp -> Run();

  return( 0 );
}
