// ============================================================================
//  $Id: TClearRunInformationModuleCommand.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TClearRunInformationModuleCommand.hh"
#include "TRunManager.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TRunInformationTable.hh"

static const Tstring _name = "/run/clearinfo";
static const Tstring _desc = "clear run information in the table.";

TClearRunInformationModuleCommand::TClearRunInformationModuleCommand( TRunManager* manager, TSoftwareRunInformationModule* module )
  : TCommand( manager, _name, _desc ), TRunInformationModuleCommand( module )
{;}

TClearRunInformationModuleCommand::~TClearRunInformationModuleCommand()
{;}

Tvoid TClearRunInformationModuleCommand::Execute( const TstringList& arguments )
{
  Tstring head = "TClearRunInformationModuleCommand::Execute: ";
  if ( theRunInformationModule == 0 ) {
    Tcerr << head << "RunInformationModule does not exist." << Tendl;
    return;
  }

  Tstatus_t status = theRunManager -> GetStatus();
  if ( status == tStatusIdle || status == tStatusStandby ) {
    theRunInformationModule -> Clear();
  } else {
    theRunManager -> ShowStatus();
    Tcerr << head << "status of RunManager must be Standby or Idle." << Tendl;
  }

  return;
}
