// ============================================================================
//  $Id: TDateCommand.hh,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TDATECOMMAND_HH
#define __TDATECOMMAND_HH

#include "Tglobals.h"
#include "TCommand.hh"
#include "TSystemClock.hh"

class TRunManager;
class TSystemClock;

class TDateCommand
  : public TCommand
{

  private:
    TSystemClock theSystemClock;

  public:
    TDateCommand( TRunManager* manager );
    ~TDateCommand();

  public:
    Tvoid Execute( const TstringList& arguments );

  public:
    const TSystemClock& GetSystemClock() const;
    Tvoid SetSystemClock( const TSystemClock& clock );

};

inline const TSystemClock& TDateCommand::GetSystemClock() const
{
  return( theSystemClock );
}

inline Tvoid TDateCommand::SetSystemClock( const TSystemClock& clock )
{
  theSystemClock = clock;
  return;
}

#endif
