// ============================================================================
//  $Id: TStreamableObject.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TStreamableObject.hh"

TStreamableObject::TStreamableObject( Tobject_t objecttype, const Tstring& id )
  : theObjectType( objecttype ), theID( id )
{;}

TStreamableObject::TStreamableObject( const TStreamableObject& right )
  : theObjectType( right.theObjectType ), theID( right.theID )
{;}

TStreamableObject::~TStreamableObject()
{;}

const TStreamableObject& TStreamableObject::operator=( const TStreamableObject& right )
{
  theObjectType = right.theObjectType;
  theID = right.theID;
  return( *this );
}

Tbool TStreamableObject::operator==( const TStreamableObject& right ) const
{
  if ( theObjectType == right.theObjectType && theID == right.theID ) {
    return( Ttrue );
  } else {
    return( Tfalse );
  }
}

Tbool TStreamableObject::operator!=( const TStreamableObject& right ) const
{
  if ( theObjectType != right.theObjectType || theID != right.theID ) {
    return( Ttrue );
  } else {
    return( Tfalse );
  }
}
