// ============================================================================
//  $Id: TStreamableObject.hh,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TSTREAMABLEOBJECT_HH
#define __TSTREAMABLEOBJECT_HH

#include "Tglobals.h"

class TOutputObjectStream;

class TStreamableObject
{

  protected:
    Tobject_t theObjectType;
    Tstring theID;

  public:
    TStreamableObject( Tobject_t objecttype, const Tstring& id );
    TStreamableObject( const TStreamableObject& right );

  public:
    Tobject_t GetObjectType() const;
    const Tstring& GetID() const;
    Tvoid SetObjectType( Tobject_t objecttype );
    Tvoid SetID( const Tstring& id );

  public:
    virtual const TStreamableObject& operator=( const TStreamableObject& right );
    virtual Tbool operator==( const TStreamableObject& right ) const;
    virtual Tbool operator!=( const TStreamableObject& right ) const;

  protected:
    virtual ~TStreamableObject();

  public:
    virtual Tint GetDataSize() = 0;
    virtual Tint WriteData( TOutputObjectStream* output ) = 0;
    virtual Tvoid Clear() = 0;
    virtual Tint Serialize( Tvoid* buffer ) = 0;

};

inline Tobject_t TStreamableObject::GetObjectType() const
{
  return( theObjectType );
}

inline const Tstring& TStreamableObject::GetID() const
{
  return( theID );
}

inline Tvoid TStreamableObject::SetObjectType( Tobject_t objecttype )
{ 
  theObjectType = objecttype;
  return;
}

inline Tvoid TStreamableObject::SetID( const Tstring& id )
{
  theID = id;
  return;
}

#endif
