// ============================================================================
//  $Id: TTerminalUserInterface.hh,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TTERMINALUSERINTERFACE_HH
#define __TTERMINALUSERINTERFACE_HH

#include "Tglobals.h"
#include "TUserInterface.hh"
#include "TCommandHistory.hh"

class TTerminalUserInterface
  : public TUserInterface
{

  private:
    Tint theCommandHistoryIndex;
    Tint theCursorPosition;
    Tstring thePrompt;
    Tstring theAcceptString;
    Tstring theStringBuffer;
    Tstring theCommandBuffer;
    //TCommandHistory theCommandHistory;
    struct termios theTerminal;

  public:
    TTerminalUserInterface( const Tstring& prompt = Tprompt, const Tstring& history = "history.last" );
    ~TTerminalUserInterface();

  public:
    Tbool AcceptCommand();
    const Tstring& GetInputCommand();
    Tvoid NotFoundCommand( const Tstring& commandname ) const;

  public:
    Tint GetCommandHistoryIndex() const;
    Tint GetCursorPosition() const;
    const Tstring& GetPrompt() const;
    const Tstring& GetAcceptString() const;
    const Tstring& GetStringBuffer() const;
    const Tstring& GetCommandBuffer() const;
    //const TCommandHistory& GetCommandHistory() const;
    //TCommandHistory& GetCommandHistory();
    Tvoid SetCommandHistoryIndex( Tint index );
    Tvoid SetCursorPosition( Tint position );
    Tvoid SetPrompt( const Tstring& prompt );
    Tvoid SetAcceptString( const Tstring& accept );
    Tvoid SetStringBuffer( const Tstring& buffer );
    Tvoid SetCommandBuffer( const Tstring& buffer );
    //Tvoid SetCommandHistory( const TCommandHistory& history );

  protected:
    const Tstring& readLine();
    Tvoid initializeCommandLine();
    Tvoid insertCharacter( Tchar cc );
    Tvoid backspaceCharacter();
    Tvoid deleteCharacter();
    Tvoid clearLine();
    Tvoid clearScreen();
    Tvoid clearAfterCursor();
    Tvoid forwardCursor();
    Tvoid backwardCursor();
    Tvoid moveCursorTop();
    Tvoid moveCursorEnd();
    Tvoid nextCommand();
    Tvoid previousCommand();
    Tvoid completeCommand();
    Tvoid cutCharacter();
    Tvoid pasteCharacter();
    Tvoid suspendTerminal() const;
    Tvoid setTerminalInputMode();
    Tvoid resetTerminal();
    Tbool isCursorEnd() const;
    Tbool isCursorTop() const;
    TstringList getArguments( const Tstring& readline );

};

inline Tint TTerminalUserInterface::GetCommandHistoryIndex() const
{
  return( theCommandHistoryIndex );
}

inline Tint TTerminalUserInterface::GetCursorPosition() const
{
  return( theCursorPosition );
}

inline const Tstring& TTerminalUserInterface::GetPrompt() const
{
  return( thePrompt );
}

inline const Tstring& TTerminalUserInterface::GetAcceptString() const
{
  return( theAcceptString );
}

inline const Tstring& TTerminalUserInterface::GetStringBuffer() const
{
  return( theStringBuffer );
}

inline const Tstring& TTerminalUserInterface::GetCommandBuffer() const
{
  return( theCommandBuffer );
}

inline const TCommandHistory& TTerminalUserInterface::GetCommandHistory() const
{
  return( theCommandHistory );
}

inline TCommandHistory& TTerminalUserInterface::GetCommandHistory()
{
  return( theCommandHistory );
}

inline Tvoid TTerminalUserInterface::SetCommandHistoryIndex( Tint index )
{
  theCommandHistoryIndex = index;
  return;
}

inline Tvoid TTerminalUserInterface::SetCursorPosition( Tint position )
{
  theCursorPosition = position;
  return;
}

inline Tvoid TTerminalUserInterface::SetPrompt( const Tstring& prompt )
{
  thePrompt = prompt;
  return;
}

inline Tvoid TTerminalUserInterface::SetAcceptString( const Tstring& accept )
{
  theAcceptString = accept;
  return;
}

inline Tvoid TTerminalUserInterface::SetStringBuffer( const Tstring& buffer )
{
  theStringBuffer = buffer;
  return;
}

inline Tvoid TTerminalUserInterface::SetCommandBuffer( const Tstring& buffer )
{
  theCommandBuffer = buffer;
  return;
}

inline Tvoid TTerminalUserInterface::SetCommandHistory( const TCommandHistory& history )
{
  theCommandHistory = history;
  return;
}

inline Tbool TTerminalUserInterface::isCursorEnd() const
{
  return( ( theCursorPosition == (Tint)( theAcceptString.size() ) ) ? Ttrue : Tfalse );
}

inline Tbool TTerminalUserInterface::isCursorTop() const
{
  return( ( theCursorPosition == 0 ) ? Ttrue : Tfalse );
}

#endif
